/*
 * Decompiled with CFR 0.152.
 */
package infra.web;

import infra.http.DefaultHttpHeaders;
import infra.http.HttpHeaders;
import infra.http.HttpStatus;
import infra.http.HttpStatusCode;
import infra.http.MediaType;
import infra.util.CollectionUtils;
import infra.web.ErrorResponse;
import infra.web.ResponseStatusException;
import java.util.Collections;
import java.util.List;

public class NotAcceptableStatusException
extends ResponseStatusException {
    private static final String PARSE_ERROR_DETAIL_CODE = ErrorResponse.getDefaultDetailMessageCode(NotAcceptableStatusException.class, "parseError");
    private final List<MediaType> supportedMediaTypes;

    public NotAcceptableStatusException(String reason) {
        super((HttpStatusCode)HttpStatus.NOT_ACCEPTABLE, reason, null, PARSE_ERROR_DETAIL_CODE, null);
        this.supportedMediaTypes = Collections.emptyList();
        this.setDetail("Could not parse Accept header.");
    }

    public NotAcceptableStatusException(List<MediaType> mediaTypes) {
        super((HttpStatusCode)HttpStatus.NOT_ACCEPTABLE, "Could not find acceptable representation", null, null, new Object[]{mediaTypes});
        this.supportedMediaTypes = Collections.unmodifiableList(mediaTypes);
        this.setDetail("Acceptable representations: %s.".formatted(mediaTypes));
    }

    @Override
    public HttpHeaders getHeaders() {
        if (CollectionUtils.isEmpty(this.supportedMediaTypes)) {
            return HttpHeaders.empty();
        }
        DefaultHttpHeaders headers = HttpHeaders.forWritable();
        headers.setAccept(this.supportedMediaTypes);
        return headers;
    }

    public List<MediaType> getSupportedMediaTypes() {
        return this.supportedMediaTypes;
    }
}

