/*
 * Decompiled with CFR 0.152.
 */
package infra.web;

import infra.http.DefaultHttpHeaders;
import infra.http.HttpHeaders;
import infra.http.HttpMethod;
import infra.http.HttpStatus;
import infra.http.HttpStatusCode;
import infra.lang.Assert;
import infra.lang.Nullable;
import infra.util.CollectionUtils;
import infra.web.ResponseStatusException;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;

public class MethodNotAllowedException
extends ResponseStatusException {
    private final String method;
    private final Set<HttpMethod> httpMethods;

    public MethodNotAllowedException(HttpMethod method, Collection<HttpMethod> supportedMethods) {
        this(method.name(), supportedMethods);
    }

    public MethodNotAllowedException(String method, @Nullable Collection<HttpMethod> supportedMethods) {
        super((HttpStatusCode)HttpStatus.METHOD_NOT_ALLOWED, "Request method '%s' is not supported.".formatted(method), null, null, new Object[]{method, supportedMethods});
        Assert.notNull((Object)method, (String)"'method' is required");
        if (supportedMethods == null) {
            supportedMethods = Collections.emptySet();
        }
        this.method = method;
        this.httpMethods = Collections.unmodifiableSet(new LinkedHashSet<HttpMethod>(supportedMethods));
        if (!this.httpMethods.isEmpty()) {
            this.setDetail("Supported methods: " + this.httpMethods);
        }
    }

    @Override
    public HttpHeaders getHeaders() {
        if (CollectionUtils.isEmpty(this.httpMethods)) {
            return HttpHeaders.empty();
        }
        DefaultHttpHeaders headers = HttpHeaders.forWritable();
        headers.setAllow(this.httpMethods);
        return headers;
    }

    public String getHttpMethod() {
        return this.method;
    }

    public Set<HttpMethod> getSupportedMethods() {
        return this.httpMethods;
    }
}

