/*
 * Decompiled with CFR 0.152.
 */
package infra.web;

import infra.lang.Nullable;
import infra.web.HandlerInterceptor;
import infra.web.HandlerWrapper;
import infra.web.RequestContext;

public abstract class InterceptorChain {
    private int currentIndex = 0;
    private final Object handler;
    private final int interceptorLength;
    private final HandlerInterceptor[] interceptors;

    protected InterceptorChain(HandlerInterceptor[] interceptors, Object handler) {
        this.interceptorLength = interceptors.length;
        this.interceptors = interceptors;
        this.handler = handler;
    }

    @Nullable
    public final Object proceed(RequestContext context) throws Throwable {
        if (this.currentIndex < this.interceptorLength) {
            return this.interceptors[this.currentIndex++].intercept(context, this);
        }
        return this.invokeHandler(context, this.handler);
    }

    @Nullable
    protected abstract Object invokeHandler(RequestContext var1, Object var2) throws Throwable;

    public HandlerInterceptor[] getInterceptors() {
        return this.interceptors;
    }

    public int getCurrentIndex() {
        return this.currentIndex;
    }

    public Object getHandler() {
        return this.handler;
    }

    public Object unwrapHandler() {
        return HandlerWrapper.unwrap(this.handler);
    }
}

