/*
 * Decompiled with CFR 0.152.
 */
package infra.web;

import infra.beans.BeanUtils;
import infra.beans.factory.BeanNameAware;
import infra.context.ApplicationContext;
import infra.context.ApplicationContextAware;
import infra.context.ApplicationContextException;
import infra.context.ApplicationContextInitializer;
import infra.context.ApplicationListener;
import infra.context.ConfigurableApplicationContext;
import infra.context.EnvironmentAware;
import infra.context.event.ContextRefreshedEvent;
import infra.context.event.SourceFilteringListener;
import infra.context.support.AbstractRefreshableConfigApplicationContext;
import infra.context.support.ClassPathXmlApplicationContext;
import infra.core.Conventions;
import infra.core.annotation.AnnotationAwareOrderComparator;
import infra.core.env.ConfigurableEnvironment;
import infra.core.env.Environment;
import infra.core.env.EnvironmentCapable;
import infra.core.env.StandardEnvironment;
import infra.lang.Assert;
import infra.lang.Nullable;
import infra.logging.Logger;
import infra.logging.LoggerFactory;
import infra.util.CollectionUtils;
import infra.util.ObjectUtils;
import infra.web.DispatcherHandler;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;

public abstract class InfraHandler
implements ApplicationContextAware,
EnvironmentCapable,
EnvironmentAware,
BeanNameAware {
    protected static final Logger log = LoggerFactory.getLogger(DispatcherHandler.class);
    private boolean applicationContextInjected;
    private Class<?> contextClass = ClassPathXmlApplicationContext.class;
    @Nullable
    private String contextId;
    @Nullable
    private String contextConfigLocation;
    private final ArrayList<ApplicationContextInitializer> contextInitializers = new ArrayList();
    private volatile boolean refreshEventReceived;
    private final Object onRefreshMonitor = new Object();
    protected String beanName = Conventions.getVariableName((Object)this);
    @Nullable
    private ConfigurableEnvironment environment;
    @Nullable
    private ApplicationContext applicationContext;
    private boolean enableLoggingRequestDetails = false;
    protected final AtomicBoolean initialized = new AtomicBoolean(false);

    protected InfraHandler() {
    }

    protected InfraHandler(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public void setBeanName(String name) {
        this.beanName = name;
    }

    public void setEnvironment(Environment environment) {
        Assert.isInstanceOf(ConfigurableEnvironment.class, (Object)environment, (String)"ConfigurableEnvironment required");
        this.environment = (ConfigurableEnvironment)environment;
    }

    public ConfigurableEnvironment getEnvironment() {
        if (this.environment == null) {
            this.environment = this.createEnvironment();
        }
        return this.environment;
    }

    protected ConfigurableEnvironment createEnvironment() {
        return new StandardEnvironment();
    }

    public void init() {
        if (this.initialized.compareAndSet(false, true)) {
            long startTime = System.currentTimeMillis();
            try {
                this.applicationContext = this.initApplicationContext();
                this.afterApplicationContextInit();
            }
            catch (Exception ex) {
                log.error("Context initialization failed", (Throwable)ex);
                throw ex;
            }
            if (log.isDebugEnabled()) {
                String value = this.isEnableLoggingRequestDetails() ? "shown which may lead to unsafe logging of potentially sensitive data" : "masked to prevent unsafe logging of potentially sensitive data";
                log.debug("enableLoggingRequestDetails='{}': request parameters and headers will be {}", (Object)this.isEnableLoggingRequestDetails(), (Object)value);
            }
            log.info("Completed initialization in {} ms", (Object)(System.currentTimeMillis() - startTime));
        }
    }

    protected void afterApplicationContextInit() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ApplicationContext initApplicationContext() {
        ConfigurableApplicationContext cwac;
        ApplicationContext rootContext = this.getRootApplicationContext();
        ApplicationContext wac = this.applicationContext;
        if (wac != null && wac instanceof ConfigurableApplicationContext && !(cwac = (ConfigurableApplicationContext)wac).isActive()) {
            if (cwac.getParent() == null && rootContext != wac) {
                cwac.setParent(rootContext);
            }
            this.configureAndRefreshApplicationContext(cwac);
        }
        if (wac == null) {
            wac = this.findApplicationContext();
        }
        if (wac == null) {
            wac = this.createApplicationContext(rootContext);
        }
        if (!this.refreshEventReceived) {
            Object object = this.onRefreshMonitor;
            synchronized (object) {
                this.onRefresh(wac);
            }
        }
        return wac;
    }

    @Nullable
    protected ApplicationContext getRootApplicationContext() {
        return null;
    }

    protected void configureAndRefreshApplicationContext(ConfigurableApplicationContext context) {
        if (ObjectUtils.identityToString((Object)context).equals(context.getId())) {
            String contextId = this.getContextId();
            if (contextId != null) {
                context.setId(contextId);
            } else {
                this.applyDefaultContextId(context);
            }
        }
        context.addApplicationListener((ApplicationListener)new SourceFilteringListener((Object)context, (ApplicationListener)new ContextRefreshListener()));
        this.postProcessApplicationContext(context);
        this.applyInitializers(context, this.contextInitializers);
        context.refresh();
    }

    protected void applyDefaultContextId(ConfigurableApplicationContext context) {
        context.setId("application");
    }

    @Nullable
    protected ApplicationContext findApplicationContext() {
        return null;
    }

    protected ApplicationContext createApplicationContext(@Nullable ApplicationContext parent) {
        Class<?> contextClass = this.getContextClass();
        if (!ConfigurableApplicationContext.class.isAssignableFrom(contextClass)) {
            throw new ApplicationContextException("Fatal initialization error: custom ApplicationContext class [%s] is not of type ConfigurableApplicationContext".formatted(contextClass.getName()));
        }
        ConfigurableApplicationContext context = (ConfigurableApplicationContext)BeanUtils.newInstance(contextClass);
        context.setEnvironment(this.getEnvironment());
        context.setParent(parent);
        String configLocation = this.getContextConfigLocation();
        if (configLocation != null && context instanceof AbstractRefreshableConfigApplicationContext) {
            AbstractRefreshableConfigApplicationContext cwac = (AbstractRefreshableConfigApplicationContext)context;
            cwac.setConfigLocation(configLocation);
        }
        this.configureAndRefreshApplicationContext(context);
        return context;
    }

    protected void postProcessApplicationContext(ConfigurableApplicationContext context) {
    }

    protected void applyInitializers(ConfigurableApplicationContext context, List<ApplicationContextInitializer> initializers) {
        AnnotationAwareOrderComparator.sort(initializers);
        for (ApplicationContextInitializer initializer : initializers) {
            initializer.initialize(context);
        }
    }

    public void refresh() {
        ApplicationContext wac = this.getApplicationContext();
        if (!(wac instanceof ConfigurableApplicationContext)) {
            throw new IllegalStateException("ApplicationContext does not support refresh: " + wac);
        }
        ConfigurableApplicationContext cac = (ConfigurableApplicationContext)wac;
        cac.refresh();
    }

    protected void onRefresh(ApplicationContext context) {
    }

    public void destroy() {
        ApplicationContext.State state;
        ApplicationContext context;
        if (!this.applicationContextInjected && (context = this.applicationContext) != null && (state = context.getState()) != ApplicationContext.State.CLOSING && state != ApplicationContext.State.CLOSED) {
            context.close();
            this.logInfo("Your application destroyed at: [%s] on startup date: [%s]".formatted(Instant.now(), context.getStartupDate()));
        }
    }

    protected void logInfo(String msg) {
        log.info(msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onApplicationEvent(ContextRefreshedEvent event) {
        this.refreshEventReceived = true;
        Object object = this.onRefreshMonitor;
        synchronized (object) {
            this.onRefresh(event.getApplicationContext());
        }
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        if (this.applicationContext == null) {
            this.applicationContext = applicationContext;
            this.applicationContextInjected = true;
        }
    }

    public final ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public void setContextClass(Class<?> contextClass) {
        this.contextClass = contextClass;
    }

    public Class<?> getContextClass() {
        return this.contextClass;
    }

    public void setContextId(@Nullable String contextId) {
        this.contextId = contextId;
    }

    @Nullable
    public String getContextId() {
        return this.contextId;
    }

    public void setContextConfigLocation(@Nullable String contextConfigLocation) {
        this.contextConfigLocation = contextConfigLocation;
    }

    @Nullable
    public String getContextConfigLocation() {
        return this.contextConfigLocation;
    }

    public void addContextInitializers(ApplicationContextInitializer ... initializers) {
        CollectionUtils.addAll(this.contextInitializers, (Object[])initializers);
    }

    public void setEnableLoggingRequestDetails(boolean enable) {
        this.enableLoggingRequestDetails = enable;
    }

    public boolean isEnableLoggingRequestDetails() {
        return this.enableLoggingRequestDetails;
    }

    private class ContextRefreshListener
    implements ApplicationListener<ContextRefreshedEvent> {
        private ContextRefreshListener() {
        }

        public void onApplicationEvent(ContextRefreshedEvent event) {
            InfraHandler.this.onApplicationEvent(event);
        }
    }
}

