/*
 * Decompiled with CFR 0.152.
 */
package infra.web;

import infra.core.Pair;
import infra.core.annotation.AnnotationUtils;
import infra.core.conversion.ConversionException;
import infra.http.HttpStatus;
import infra.http.HttpStatusCode;
import infra.util.StringUtils;
import infra.web.annotation.ResponseStatus;

public interface HttpStatusProvider {
    public HttpStatusCode getStatusCode();

    public static Pair<HttpStatusCode, String> getStatusCode(Throwable ex) {
        if (ex instanceof HttpStatusProvider) {
            HttpStatusProvider provider = (HttpStatusProvider)((Object)ex);
            return Pair.of((Object)provider.getStatusCode(), (Object)ex.getMessage());
        }
        if (ex instanceof ConversionException) {
            return Pair.of((Object)HttpStatus.BAD_REQUEST, (Object)ex.getMessage());
        }
        ResponseStatus status = (ResponseStatus)AnnotationUtils.getAnnotation(ex.getClass(), ResponseStatus.class);
        if (status != null) {
            String reason = status.reason();
            return Pair.of((Object)status.code(), (Object)(StringUtils.hasText((String)reason) ? reason : ex.getMessage()));
        }
        return Pair.of((Object)HttpStatus.INTERNAL_SERVER_ERROR, (Object)ex.getMessage());
    }
}

