/*
 * Decompiled with CFR 0.152.
 */
package infra.web;

import infra.core.NestedRuntimeException;
import infra.http.DefaultHttpHeaders;
import infra.http.HttpHeaders;
import infra.http.HttpMethod;
import infra.http.HttpStatus;
import infra.http.HttpStatusCode;
import infra.http.ProblemDetail;
import infra.lang.Nullable;
import infra.util.ObjectUtils;
import infra.util.StringUtils;
import infra.web.ErrorResponse;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;

public class HttpRequestMethodNotSupportedException
extends NestedRuntimeException
implements ErrorResponse {
    private final String method;
    @Nullable
    private final String[] supportedMethods;
    private final ProblemDetail body;

    public HttpRequestMethodNotSupportedException(String method) {
        this(method, (String[])null);
    }

    public HttpRequestMethodNotSupportedException(String method, @Nullable Collection<String> supportedMethods) {
        this(method, supportedMethods != null ? StringUtils.toStringArray(supportedMethods) : null);
    }

    private HttpRequestMethodNotSupportedException(String method, @Nullable String[] supportedMethods) {
        super("Request method '%s' is not supported".formatted(method));
        this.method = method;
        this.supportedMethods = supportedMethods;
        String detail = "Method '%s' is not supported.".formatted(method);
        this.body = ProblemDetail.forStatusAndDetail(this.getStatusCode(), detail);
    }

    public String getMethod() {
        return this.method;
    }

    @Nullable
    public String[] getSupportedMethods() {
        return this.supportedMethods;
    }

    @Nullable
    public Set<HttpMethod> getSupportedHttpMethods() {
        if (this.supportedMethods == null) {
            return null;
        }
        LinkedHashSet<HttpMethod> supportedMethods = new LinkedHashSet<HttpMethod>(this.supportedMethods.length);
        for (String value : this.supportedMethods) {
            HttpMethod method = HttpMethod.valueOf(value);
            supportedMethods.add(method);
        }
        return supportedMethods;
    }

    @Override
    public HttpStatusCode getStatusCode() {
        return HttpStatus.METHOD_NOT_ALLOWED;
    }

    @Override
    public HttpHeaders getHeaders() {
        if (ObjectUtils.isEmpty((Object[])this.supportedMethods)) {
            return HttpHeaders.empty();
        }
        DefaultHttpHeaders headers = HttpHeaders.forWritable();
        headers.setAllow(this.supportedMethods);
        return headers;
    }

    @Override
    public ProblemDetail getBody() {
        return this.body;
    }

    @Override
    public Object[] getDetailMessageArguments() {
        return new Object[]{this.getMethod(), this.getSupportedHttpMethods()};
    }
}

