/*
 * Decompiled with CFR 0.152.
 */
package infra.web;

import infra.http.DefaultHttpHeaders;
import infra.http.HttpHeaders;
import infra.http.HttpMethod;
import infra.http.HttpStatus;
import infra.http.HttpStatusCode;
import infra.http.MediaType;
import infra.lang.Nullable;
import infra.util.CollectionUtils;
import infra.web.ErrorResponse;
import infra.web.HttpMediaTypeException;
import java.util.Collections;
import java.util.List;

public class HttpMediaTypeNotSupportedException
extends HttpMediaTypeException {
    private static final String PARSE_ERROR_DETAIL_CODE = ErrorResponse.getDefaultDetailMessageCode(HttpMediaTypeNotSupportedException.class, "parseError");
    @Nullable
    private final MediaType contentType;
    @Nullable
    private final HttpMethod httpMethod;

    public HttpMediaTypeNotSupportedException(String message) {
        this(message, Collections.emptyList());
    }

    public HttpMediaTypeNotSupportedException(@Nullable String message, List<MediaType> mediaTypes) {
        super(message, mediaTypes, PARSE_ERROR_DETAIL_CODE, null);
        this.contentType = null;
        this.httpMethod = null;
        this.getBody().setDetail("Could not parse Content-Type.");
    }

    public HttpMediaTypeNotSupportedException(@Nullable MediaType contentType, List<MediaType> mediaTypes) {
        this(contentType, mediaTypes, null);
    }

    public HttpMediaTypeNotSupportedException(@Nullable MediaType contentType, List<MediaType> mediaTypes, @Nullable HttpMethod httpMethod) {
        this(contentType, mediaTypes, httpMethod, "Content-Type %sis not supported".formatted(contentType != null ? "'" + contentType + "' " : ""));
    }

    public HttpMediaTypeNotSupportedException(@Nullable MediaType contentType, List<MediaType> supportedMediaTypes, @Nullable HttpMethod httpMethod, String message) {
        super(message, supportedMediaTypes, null, new Object[]{contentType, supportedMediaTypes});
        this.contentType = contentType;
        this.httpMethod = httpMethod;
        this.getBody().setDetail("Content-Type '%s' is not supported.".formatted(this.contentType));
    }

    @Nullable
    public MediaType getContentType() {
        return this.contentType;
    }

    @Override
    public HttpStatusCode getStatusCode() {
        return HttpStatus.UNSUPPORTED_MEDIA_TYPE;
    }

    @Override
    public HttpHeaders getHeaders() {
        if (CollectionUtils.isEmpty(this.getSupportedMediaTypes())) {
            return HttpHeaders.empty();
        }
        DefaultHttpHeaders headers = HttpHeaders.forWritable();
        headers.setAccept(this.getSupportedMediaTypes());
        if (this.httpMethod == HttpMethod.PATCH) {
            headers.setAcceptPatch(this.getSupportedMediaTypes());
        }
        return headers;
    }
}

