/*
 * Decompiled with CFR 0.152.
 */
package infra.web;

import infra.http.DefaultHttpHeaders;
import infra.http.HttpHeaders;
import infra.http.HttpStatus;
import infra.http.HttpStatusCode;
import infra.http.MediaType;
import infra.util.CollectionUtils;
import infra.web.ErrorResponse;
import infra.web.HttpMediaTypeException;
import java.util.Collections;
import java.util.List;

public class HttpMediaTypeNotAcceptableException
extends HttpMediaTypeException {
    private static final String PARSE_ERROR_DETAIL_CODE = ErrorResponse.getDefaultDetailMessageCode(HttpMediaTypeNotAcceptableException.class, "parseError");

    public HttpMediaTypeNotAcceptableException(String message) {
        super(message, Collections.emptyList(), PARSE_ERROR_DETAIL_CODE, null);
        this.getBody().setDetail("Could not parse Accept header.");
    }

    public HttpMediaTypeNotAcceptableException(List<MediaType> mediaTypes) {
        super("No acceptable representation", mediaTypes, null, new Object[]{mediaTypes});
        this.getBody().setDetail("Acceptable representations: %s.".formatted(mediaTypes));
    }

    @Override
    public HttpStatusCode getStatusCode() {
        return HttpStatus.NOT_ACCEPTABLE;
    }

    @Override
    public HttpHeaders getHeaders() {
        if (CollectionUtils.isEmpty(this.getSupportedMediaTypes())) {
            return HttpHeaders.empty();
        }
        DefaultHttpHeaders headers = HttpHeaders.forWritable();
        headers.setAccept(this.getSupportedMediaTypes());
        return headers;
    }
}

