/*
 * Decompiled with CFR 0.152.
 */
package infra.web;

import infra.core.NestedRuntimeException;
import infra.http.MediaType;
import infra.http.ProblemDetail;
import infra.lang.Nullable;
import infra.web.ErrorResponse;
import java.util.Collections;
import java.util.List;

public abstract class HttpMediaTypeException
extends NestedRuntimeException
implements ErrorResponse {
    private final List<MediaType> supportedMediaTypes;
    private final ProblemDetail body = ProblemDetail.forStatus(this.getStatusCode());
    private final String messageDetailCode;
    @Nullable
    private final Object[] messageDetailArguments;

    protected HttpMediaTypeException(@Nullable String message, List<MediaType> supportedMediaTypes, @Nullable String messageDetailCode, @Nullable Object[] messageDetailArguments) {
        super(message);
        this.messageDetailArguments = messageDetailArguments;
        this.supportedMediaTypes = Collections.unmodifiableList(supportedMediaTypes);
        this.messageDetailCode = messageDetailCode != null ? messageDetailCode : ErrorResponse.getDefaultDetailMessageCode(this.getClass(), null);
    }

    public List<MediaType> getSupportedMediaTypes() {
        return this.supportedMediaTypes;
    }

    @Override
    public ProblemDetail getBody() {
        return this.body;
    }

    @Override
    public String getDetailMessageCode() {
        return this.messageDetailCode;
    }

    @Override
    @Nullable
    public Object[] getDetailMessageArguments() {
        return this.messageDetailArguments;
    }
}

