/*
 * Decompiled with CFR 0.152.
 */
package infra.web;

import infra.http.MediaType;
import infra.http.server.PathContainer;
import infra.lang.NullValue;
import infra.lang.Nullable;
import infra.util.CollectionUtils;
import infra.util.MultiValueMap;
import infra.web.RequestContext;
import infra.web.util.pattern.PathMatchInfo;
import infra.web.util.pattern.PathPattern;
import infra.web.util.pattern.PathPatternParser;
import java.util.LinkedHashMap;
import java.util.Map;

public class HandlerMatchingMetadata {
    private Object handler;
    private final String directLookupPath;
    private final PathContainer lookupPath;
    @Nullable
    private PathPattern bestMatchingPattern;
    @Nullable
    private PathContainer pathWithinMapping;
    @Nullable
    private PathMatchInfo pathMatchInfo;
    @Nullable
    private MediaType[] producibleMediaTypes;
    private final PathPatternParser patternParser;
    @Nullable
    private Map<String, Object> pathVariables;

    public HandlerMatchingMetadata(RequestContext request) {
        this(NullValue.INSTANCE, request);
    }

    public HandlerMatchingMetadata(Object handler, RequestContext request) {
        this.handler = handler;
        this.bestMatchingPattern = null;
        this.lookupPath = request.getRequestPath();
        this.directLookupPath = this.lookupPath.value();
        this.patternParser = PathPatternParser.defaultInstance;
    }

    public HandlerMatchingMetadata(Object handler, RequestContext request, PathPatternParser patternParser) {
        this.handler = handler;
        this.bestMatchingPattern = null;
        this.lookupPath = request.getRequestPath();
        this.directLookupPath = this.lookupPath.value();
        this.patternParser = patternParser;
    }

    public HandlerMatchingMetadata(Object handler, String directLookupPath, PathContainer lookupPath, @Nullable PathPattern bestMatchingPattern, PathPatternParser patternParser) {
        this.handler = handler;
        this.lookupPath = lookupPath;
        this.patternParser = patternParser;
        this.directLookupPath = directLookupPath;
        this.bestMatchingPattern = bestMatchingPattern;
    }

    public HandlerMatchingMetadata(HandlerMatchingMetadata other) {
        this.handler = other.handler;
        this.lookupPath = other.lookupPath;
        this.pathVariables = other.pathVariables;
        this.pathMatchInfo = other.pathMatchInfo;
        this.patternParser = other.patternParser;
        this.directLookupPath = other.directLookupPath;
        this.pathWithinMapping = other.pathWithinMapping;
        this.bestMatchingPattern = other.bestMatchingPattern;
        this.producibleMediaTypes = other.producibleMediaTypes;
    }

    public PathMatchInfo getPathMatchInfo() {
        PathMatchInfo pathMatchInfo = this.pathMatchInfo;
        if (pathMatchInfo == null) {
            pathMatchInfo = this.getBestMatchingPattern().matchAndExtract(this.lookupPath);
            if (pathMatchInfo == null) {
                pathMatchInfo = PathMatchInfo.EMPTY;
            }
            this.pathMatchInfo = pathMatchInfo;
        }
        return pathMatchInfo;
    }

    public PathContainer getPathWithinMapping() {
        PathContainer pathWithinMapping = this.pathWithinMapping;
        if (pathWithinMapping == null) {
            PathPattern bestMatchingPattern = this.getBestMatchingPattern();
            pathWithinMapping = bestMatchingPattern.hasPatternSyntax() ? bestMatchingPattern.extractPathWithinPattern(this.lookupPath) : this.lookupPath;
            this.pathWithinMapping = pathWithinMapping;
        }
        return pathWithinMapping;
    }

    public Map<String, Object> getPathVariables() {
        LinkedHashMap pathVariables = this.pathVariables;
        if (pathVariables == null) {
            this.pathVariables = pathVariables = CollectionUtils.newLinkedHashMap((int)this.getUriVariables().size());
        }
        return pathVariables;
    }

    public boolean hasPathVariables() {
        return this.pathVariables != null;
    }

    public Map<String, String> getUriVariables() {
        return this.getPathMatchInfo().getUriVariables();
    }

    @Nullable
    public String getUriVariable(String name) {
        return this.getPathMatchInfo().getUriVariable(name);
    }

    public Map<String, MultiValueMap<String, String>> getMatrixVariables() {
        return this.getPathMatchInfo().getMatrixVariables();
    }

    public MultiValueMap<String, String> getMatrixVariable(String name) {
        return this.getPathMatchInfo().getMatrixVariables().get(name);
    }

    public PathPattern getBestMatchingPattern() {
        PathPattern pattern = this.bestMatchingPattern;
        if (pattern == null) {
            this.bestMatchingPattern = pattern = this.patternParser.parse(this.directLookupPath);
        }
        return pattern;
    }

    public PathContainer getLookupPath() {
        return this.lookupPath;
    }

    public String getDirectLookupPath() {
        return this.directLookupPath;
    }

    public void setProducibleMediaTypes(@Nullable MediaType[] producibleMediaTypes) {
        this.producibleMediaTypes = producibleMediaTypes;
    }

    @Nullable
    public MediaType[] getProducibleMediaTypes() {
        return this.producibleMediaTypes;
    }

    public Object getHandler() {
        return this.handler;
    }

    public void setHandler(Object handler) {
        this.handler = handler;
    }
}

