/*
 * Decompiled with CFR 0.152.
 */
package infra.web;

import infra.beans.factory.BeanFactory;
import infra.beans.factory.BeanFactoryUtils;
import infra.beans.factory.config.AutowireCapableBeanFactory;
import infra.context.ApplicationContext;
import infra.core.annotation.AnnotationAwareOrderComparator;
import infra.lang.Nullable;
import infra.web.RequestContext;
import infra.web.handler.BeanNameUrlHandlerMapping;
import infra.web.handler.HandlerRegistries;
import infra.web.handler.function.support.RouterFunctionMapping;
import infra.web.handler.method.RequestMappingHandlerMapping;
import java.util.ArrayList;
import java.util.Map;

@FunctionalInterface
public interface HandlerMapping {
    public static final String HANDLER_MAPPING_BEAN_NAME = "handlerMapping";

    @Nullable
    public Object getHandler(RequestContext var1) throws Exception;

    public static HandlerMapping find(ApplicationContext context) {
        return HandlerMapping.find(context, true);
    }

    public static HandlerMapping find(ApplicationContext context, boolean detectAllHandlerMapping) {
        if (detectAllHandlerMapping) {
            Map matchingBeans = BeanFactoryUtils.beansOfTypeIncludingAncestors((BeanFactory)context, HandlerMapping.class, (boolean)true, (boolean)false);
            if (!matchingBeans.isEmpty()) {
                ArrayList<HandlerMapping> registries = new ArrayList<HandlerMapping>(matchingBeans.values());
                AnnotationAwareOrderComparator.sort(registries);
                return registries.size() == 1 ? (HandlerMapping)registries.get(0) : new HandlerRegistries(registries);
            }
        } else {
            HandlerMapping handlerMapping = (HandlerMapping)BeanFactoryUtils.find((BeanFactory)context, (String)HANDLER_MAPPING_BEAN_NAME, HandlerMapping.class);
            if (handlerMapping != null) {
                return handlerMapping;
            }
        }
        AutowireCapableBeanFactory factory = context.getAutowireCapableBeanFactory();
        return new HandlerRegistries((HandlerMapping)factory.createBean(RequestMappingHandlerMapping.class), (HandlerMapping)factory.createBean(RouterFunctionMapping.class), (HandlerMapping)factory.createBean(BeanNameUrlHandlerMapping.class));
    }
}

