/*
 * Decompiled with CFR 0.152.
 */
package infra.web;

import infra.lang.Nullable;
import infra.web.HttpRequestHandler;
import infra.web.InterceptorChain;
import infra.web.RequestContext;

public interface HandlerInterceptor {
    public static final HandlerInterceptor[] EMPTY_ARRAY = new HandlerInterceptor[0];
    public static final Object NONE_RETURN_VALUE = HttpRequestHandler.NONE_RETURN_VALUE;

    default public boolean beforeProcess(RequestContext request, Object handler) throws Throwable {
        return true;
    }

    default public void afterProcess(RequestContext request, Object handler, @Nullable Object result) throws Throwable {
    }

    @Nullable
    default public Object intercept(RequestContext request, InterceptorChain chain) throws Throwable {
        Object handler = chain.getHandler();
        if (this.beforeProcess(request, handler)) {
            Object result = chain.proceed(request);
            this.afterProcess(request, handler, result);
            return result;
        }
        return NONE_RETURN_VALUE;
    }
}

