/*
 * Decompiled with CFR 0.152.
 */
package infra.web;

import infra.beans.factory.BeanFactory;
import infra.beans.factory.BeanFactoryUtils;
import infra.context.ApplicationContext;
import infra.core.annotation.AnnotationAwareOrderComparator;
import infra.lang.Nullable;
import infra.util.CollectionUtils;
import infra.web.HttpRequestHandler;
import infra.web.RequestContext;
import infra.web.handler.CompositeHandlerExceptionHandler;
import infra.web.handler.SimpleHandlerExceptionHandler;
import infra.web.handler.method.ExceptionHandlerAnnotationExceptionHandler;
import java.util.ArrayList;
import java.util.Map;

public interface HandlerExceptionHandler {
    public static final String BEAN_NAME = "handlerExceptionHandler";
    public static final Object NONE_RETURN_VALUE = HttpRequestHandler.NONE_RETURN_VALUE;

    @Nullable
    public Object handleException(RequestContext var1, Throwable var2, @Nullable Object var3) throws Exception;

    public static HandlerExceptionHandler find(ApplicationContext context) {
        return HandlerExceptionHandler.find(context, true);
    }

    public static HandlerExceptionHandler find(ApplicationContext context, boolean detectAllHandlerExceptionHandlers) {
        HandlerExceptionHandler exceptionHandler;
        if (detectAllHandlerExceptionHandlers) {
            Map matchingBeans = BeanFactoryUtils.beansOfTypeIncludingAncestors((BeanFactory)context, HandlerExceptionHandler.class, (boolean)true, (boolean)false);
            if (!matchingBeans.isEmpty()) {
                ArrayList<HandlerExceptionHandler> handlers = new ArrayList<HandlerExceptionHandler>(matchingBeans.values());
                if (handlers.size() == 1) {
                    return (HandlerExceptionHandler)handlers.get(0);
                }
                AnnotationAwareOrderComparator.sort(handlers);
                return new CompositeHandlerExceptionHandler(handlers);
            }
        } else {
            exceptionHandler = (HandlerExceptionHandler)BeanFactoryUtils.find((BeanFactory)context, (String)BEAN_NAME, HandlerExceptionHandler.class);
            if (exceptionHandler != null) {
                return exceptionHandler;
            }
        }
        exceptionHandler = new ExceptionHandlerAnnotationExceptionHandler();
        ((ExceptionHandlerAnnotationExceptionHandler)exceptionHandler).setApplicationContext(context);
        ((ExceptionHandlerAnnotationExceptionHandler)exceptionHandler).afterPropertiesSet();
        return new CompositeHandlerExceptionHandler(CollectionUtils.newArrayList((Object[])new HandlerExceptionHandler[]{exceptionHandler, new SimpleHandlerExceptionHandler()}));
    }
}

