/*
 * Decompiled with CFR 0.152.
 */
package infra.web;

import infra.beans.factory.BeanFactory;
import infra.beans.factory.BeanFactoryUtils;
import infra.context.ApplicationContext;
import infra.core.annotation.AnnotationAwareOrderComparator;
import infra.lang.Nullable;
import infra.web.HttpRequestHandler;
import infra.web.RequestContext;
import infra.web.handler.HandlerAdapters;
import infra.web.handler.function.support.HandlerFunctionAdapter;
import infra.web.handler.method.RequestMappingHandlerAdapter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public interface HandlerAdapter {
    public static final String HANDLER_ADAPTER_BEAN_NAME = "handlerAdapter";
    public static final Object NONE_RETURN_VALUE = HttpRequestHandler.NONE_RETURN_VALUE;

    public boolean supports(Object var1);

    @Nullable
    public Object handle(RequestContext var1, Object var2) throws Throwable;

    public static HandlerAdapter of(List<HandlerAdapter> handlerAdapters) {
        return new HandlerAdapters(handlerAdapters.toArray(new HandlerAdapter[0]));
    }

    public static HandlerAdapter find(ApplicationContext context) {
        return HandlerAdapter.find(context, true);
    }

    public static HandlerAdapter find(ApplicationContext context, boolean detectAllHandlerAdapters) {
        HandlerAdapter handlerAdapter;
        if (detectAllHandlerAdapters) {
            Map matchingBeans = BeanFactoryUtils.beansOfTypeIncludingAncestors((BeanFactory)context, HandlerAdapter.class, (boolean)true, (boolean)false);
            if (!matchingBeans.isEmpty()) {
                ArrayList handlerAdapters = new ArrayList(matchingBeans.values());
                AnnotationAwareOrderComparator.sort(handlerAdapters);
                return new HandlerAdapters(handlerAdapters.toArray(new HandlerAdapter[0]));
            }
        } else {
            handlerAdapter = (HandlerAdapter)BeanFactoryUtils.find((BeanFactory)context, (String)HANDLER_ADAPTER_BEAN_NAME, HandlerAdapter.class);
            if (handlerAdapter != null) {
                return handlerAdapter;
            }
        }
        handlerAdapter = (RequestMappingHandlerAdapter)context.getAutowireCapableBeanFactory().createBean(RequestMappingHandlerAdapter.class);
        return new HandlerAdapters(new HandlerAdapter[]{handlerAdapter, new HandlerFunctionAdapter()});
    }
}

