/*
 * Decompiled with CFR 0.152.
 */
package infra.web;

import infra.core.NestedRuntimeException;
import infra.http.HttpHeaders;
import infra.http.HttpStatusCode;
import infra.http.ProblemDetail;
import infra.lang.Nullable;
import infra.web.ErrorResponse;
import java.net.URI;

public class ErrorResponseException
extends NestedRuntimeException
implements ErrorResponse {
    private final HttpStatusCode status;
    private final HttpHeaders headers = HttpHeaders.forWritable();
    private final ProblemDetail body;
    private final String messageDetailCode;
    @Nullable
    private final Object[] messageDetailArguments;

    public ErrorResponseException(HttpStatusCode status, @Nullable Throwable cause) {
        this(status, ProblemDetail.forStatus(status), cause);
    }

    public ErrorResponseException(HttpStatusCode status, ProblemDetail body, @Nullable Throwable cause) {
        this(status, body, cause, null, null);
    }

    public ErrorResponseException(HttpStatusCode status, ProblemDetail body, @Nullable Throwable cause, @Nullable String messageDetailCode, @Nullable Object[] messageDetailArguments) {
        super(null, cause);
        this.status = status;
        this.body = body;
        if (messageDetailCode == null) {
            messageDetailCode = ErrorResponse.getDefaultDetailMessageCode(this.getClass(), null);
        }
        this.messageDetailCode = messageDetailCode;
        this.messageDetailArguments = messageDetailArguments;
    }

    @Override
    public HttpStatusCode getStatusCode() {
        return this.status;
    }

    @Override
    public HttpHeaders getHeaders() {
        return this.headers;
    }

    public void setType(URI type) {
        this.body.setType(type);
    }

    public void setTitle(@Nullable String title) {
        this.body.setTitle(title);
    }

    public void setDetail(@Nullable String detail) {
        this.body.setDetail(detail);
    }

    public void setInstance(@Nullable URI instance) {
        this.body.setInstance(instance);
    }

    @Override
    public final ProblemDetail getBody() {
        return this.body;
    }

    @Override
    public String getDetailMessageCode() {
        return this.messageDetailCode;
    }

    @Override
    @Nullable
    public Object[] getDetailMessageArguments() {
        return this.messageDetailArguments;
    }

    public String getMessage() {
        return this.status + (String)(!this.headers.isEmpty() ? ", headers=" + this.headers : "") + ", " + this.body;
    }
}

