/*
 * Decompiled with CFR 0.152.
 */
package infra.web;

import infra.beans.factory.BeanFactory;
import infra.beans.factory.BeanFactoryUtils;
import infra.beans.factory.NoSuchBeanDefinitionException;
import infra.context.ApplicationContext;
import infra.core.Pair;
import infra.core.annotation.AnnotationAwareOrderComparator;
import infra.http.HttpHeaders;
import infra.http.HttpStatus;
import infra.http.HttpStatusCode;
import infra.lang.Assert;
import infra.lang.Nullable;
import infra.util.ArrayHolder;
import infra.util.ExceptionUtils;
import infra.util.StringUtils;
import infra.web.HandlerAdapter;
import infra.web.HandlerAdapterProvider;
import infra.web.HandlerExceptionHandler;
import infra.web.HandlerMapping;
import infra.web.HandlerMatchingMetadata;
import infra.web.HandlerWrapper;
import infra.web.HttpRequestHandler;
import infra.web.HttpStatusProvider;
import infra.web.InfraHandler;
import infra.web.NotFoundHandler;
import infra.web.RequestCompletedListener;
import infra.web.RequestContext;
import infra.web.ReturnValueHandler;
import infra.web.async.WebAsyncManagerFactory;
import infra.web.handler.AsyncHandler;
import infra.web.handler.HandlerAdapterAware;
import infra.web.handler.HandlerNotFoundException;
import infra.web.handler.ReturnValueHandlerManager;
import infra.web.handler.ReturnValueHandlerNotFoundException;
import infra.web.handler.result.AsyncReturnValueHandler;
import infra.web.util.WebUtils;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.stream.Collectors;

public class DispatcherHandler
extends InfraHandler {
    private HandlerMapping handlerMapping;
    private HandlerAdapter handlerAdapter;
    private HandlerExceptionHandler exceptionHandler;
    private ReturnValueHandlerManager returnValueHandler;
    private boolean throwExceptionIfNoHandlerFound = false;
    private boolean detectAllHandlerMapping = true;
    private boolean detectAllHandlerAdapters = true;
    private boolean detectAllHandlerExceptionHandlers = true;
    private NotFoundHandler notFoundHandler;
    private final ArrayHolder<RequestCompletedListener> requestCompletedActions = ArrayHolder.forGenerator(RequestCompletedListener[]::new);
    protected WebAsyncManagerFactory webAsyncManagerFactory;

    public DispatcherHandler() {
    }

    public DispatcherHandler(ApplicationContext context) {
        super(context);
    }

    @Override
    protected void onRefresh(ApplicationContext context) {
        this.initStrategies(context);
    }

    protected void initStrategies(ApplicationContext context) {
        this.initHandlerMapping(context);
        this.initHandlerAdapters(context);
        this.initReturnValueHandler(context);
        this.initExceptionHandler(context);
        this.initNotFoundHandler(context);
        this.initWebAsyncManagerFactory(context);
        this.initRequestCompletedListeners(context);
    }

    private void initHandlerMapping(ApplicationContext context) {
        if (this.handlerMapping == null) {
            this.setHandlerMapping(HandlerMapping.find(context, this.detectAllHandlerMapping));
            this.logStrategy(this.handlerMapping);
        }
    }

    private void initHandlerAdapters(ApplicationContext context) {
        if (this.handlerAdapter == null) {
            this.setHandlerAdapter(HandlerAdapter.find(context, this.detectAllHandlerAdapters));
            this.logStrategy(this.handlerAdapter);
        }
    }

    private void initReturnValueHandler(ApplicationContext context) {
        if (this.returnValueHandler == null) {
            ReturnValueHandlerManager manager;
            try {
                manager = (ReturnValueHandlerManager)BeanFactoryUtils.beanOfTypeIncludingAncestors((BeanFactory)context, ReturnValueHandlerManager.class);
            }
            catch (NoSuchBeanDefinitionException e) {
                manager = new ReturnValueHandlerManager();
                manager.setApplicationContext(context);
                manager.registerDefaultHandlers();
            }
            this.setReturnValueHandler(manager);
            this.logStrategy(manager);
        }
    }

    private void initExceptionHandler(ApplicationContext context) {
        if (this.exceptionHandler == null) {
            this.setExceptionHandler(HandlerExceptionHandler.find(context, this.detectAllHandlerExceptionHandlers));
            this.logStrategy(this.exceptionHandler);
        }
    }

    private void initNotFoundHandler(ApplicationContext context) {
        if (this.notFoundHandler == null) {
            this.notFoundHandler = (NotFoundHandler)BeanFactoryUtils.find((BeanFactory)context, NotFoundHandler.class);
            if (this.notFoundHandler == null) {
                this.setNotFoundHandler(NotFoundHandler.sharedInstance);
            }
            this.logStrategy(this.notFoundHandler);
        }
    }

    private void initWebAsyncManagerFactory(ApplicationContext context) {
        if (this.webAsyncManagerFactory == null) {
            this.setWebAsyncManagerFactory(WebAsyncManagerFactory.find(context));
            this.logStrategy(this.webAsyncManagerFactory);
        }
    }

    private void initRequestCompletedListeners(ApplicationContext context) {
        Map matchingBeans = BeanFactoryUtils.beansOfTypeIncludingAncestors((BeanFactory)context, RequestCompletedListener.class, (boolean)true, (boolean)false);
        ArrayList<RequestCompletedListener> handlers = new ArrayList<RequestCompletedListener>(matchingBeans.values());
        AnnotationAwareOrderComparator.sort(handlers);
        this.addRequestCompletedActions(handlers);
    }

    @Nullable
    public Object lookupHandler(RequestContext context) throws Exception {
        return this.handlerMapping.getHandler(context);
    }

    public void handleConcurrentResult(RequestContext context, @Nullable Object handler, @Nullable Object concurrentResult) throws Throwable {
        Throwable throwable = null;
        try {
            if (handler instanceof AsyncHandler) {
                AsyncHandler asyncHandler = (AsyncHandler)handler;
                handler = asyncHandler.wrapConcurrentResult(concurrentResult);
            }
            if (handler instanceof AsyncReturnValueHandler) {
                AsyncReturnValueHandler valueHandler = (AsyncReturnValueHandler)handler;
                valueHandler.handleAsyncReturnValue(context, concurrentResult);
            } else {
                if (concurrentResult instanceof Throwable) {
                    Throwable asyncError;
                    throwable = asyncError = (Throwable)concurrentResult;
                }
                this.processDispatchResult(context, handler, concurrentResult, throwable);
                throwable = null;
            }
        }
        catch (Throwable ex) {
            throwable = ex;
        }
        this.logResult(context, throwable);
        this.requestCompleted(context, throwable);
    }

    public void handleRequest(RequestContext context) throws Throwable {
        this.logRequest(context);
        Object handler = null;
        Object returnValue = null;
        Throwable throwable = null;
        try {
            handler = this.lookupHandler(context);
            if (handler == null) {
                returnValue = this.handlerNotFound(context);
            } else {
                if (handler instanceof HandlerAdapterAware) {
                    HandlerAdapterAware aware = (HandlerAdapterAware)handler;
                    aware.setHandlerAdapter(this.handlerAdapter);
                }
                if (handler instanceof HttpRequestHandler) {
                    HttpRequestHandler requestHandler = (HttpRequestHandler)handler;
                    returnValue = requestHandler.handleRequest(context);
                } else {
                    returnValue = this.lookupHandlerAdapter(handler).handle(context, handler);
                }
            }
        }
        catch (Throwable ex) {
            throwable = ex;
        }
        try {
            this.processDispatchResult(context, handler, returnValue, throwable);
            throwable = null;
        }
        catch (Throwable ex) {
            throwable = ex;
        }
        this.logResult(context, throwable);
        if (!context.isConcurrentHandlingStarted()) {
            this.requestCompleted(context, throwable);
        }
    }

    private HandlerAdapter lookupHandlerAdapter(@Nullable Object handler) {
        if (handler instanceof HandlerAdapter) {
            return (HandlerAdapter)handler;
        }
        if (handler instanceof HandlerAdapterProvider) {
            return ((HandlerAdapterProvider)handler).getHandlerAdapter();
        }
        return this.handlerAdapter;
    }

    protected void processDispatchResult(RequestContext request, @Nullable Object handler, @Nullable Object returnValue, @Nullable Throwable exception) throws Throwable {
        if (handler instanceof HandlerWrapper) {
            HandlerWrapper wrapper = (HandlerWrapper)handler;
            handler = wrapper.getRawHandler();
        }
        if (exception != null) {
            exception = ExceptionUtils.unwrapIfNecessary((Throwable)exception);
            returnValue = this.processHandlerException(request, handler, exception);
            HandlerMatchingMetadata matchingMetadata = request.getMatchingMetadata();
            handler = matchingMetadata != null ? matchingMetadata.getHandler() : null;
        }
        if (returnValue != HttpRequestHandler.NONE_RETURN_VALUE) {
            ReturnValueHandler selected;
            if (handler instanceof ReturnValueHandler) {
                selected = (ReturnValueHandler)handler;
            } else {
                selected = this.returnValueHandler.selectHandler(handler, returnValue);
                if (selected == null) {
                    if (returnValue == null && handler != null) {
                        throw new ReturnValueHandlerNotFoundException(handler);
                    }
                    throw new ReturnValueHandlerNotFoundException(returnValue, handler);
                }
            }
            try {
                selected.handleReturnValue(request, handler, returnValue);
            }
            catch (Throwable e) {
                if (exception == null) {
                    this.processDispatchResult(request, handler, null, e);
                }
                throw e;
            }
        }
    }

    @Nullable
    protected Object processHandlerException(RequestContext request, @Nullable Object handler, Throwable ex) throws Throwable {
        HandlerMatchingMetadata matchingMetadata = request.getMatchingMetadata();
        if (matchingMetadata != null) {
            matchingMetadata.setProducibleMediaTypes(null);
        }
        request.reset();
        request.setAttribute(WebUtils.ERROR_EXCEPTION_ATTRIBUTE, ex);
        Object returnValue = this.exceptionHandler.handleException(request, ex, handler);
        if (returnValue == null) {
            throw ex;
        }
        if (returnValue != HttpRequestHandler.NONE_RETURN_VALUE) {
            if (log.isTraceEnabled()) {
                log.trace("Using resolved error view: {}", returnValue, (Object)ex);
            } else if (log.isDebugEnabled()) {
                log.debug("Using resolved error view: {}", returnValue);
            }
        }
        return returnValue;
    }

    @Nullable
    protected Object handlerNotFound(RequestContext request) throws Throwable {
        if (this.throwExceptionIfNoHandlerFound) {
            throw new HandlerNotFoundException(request.getMethodValue(), request.getRequestURI(), request.requestHeaders());
        }
        return this.notFoundHandler.handleNotFound(request);
    }

    protected void requestCompleted(RequestContext request, @Nullable Throwable notHandled) throws Throwable {
        RequestCompletedListener[] actions = (RequestCompletedListener[])this.requestCompletedActions.array;
        if (actions != null) {
            for (RequestCompletedListener action : actions) {
                action.requestCompleted(request, notHandled);
            }
        }
        if (notHandled != null) {
            try {
                Pair<HttpStatusCode, String> httpStatus = HttpStatusProvider.getStatusCode(notHandled);
                request.sendError((HttpStatusCode)httpStatus.first, (String)httpStatus.second);
            }
            catch (Throwable e) {
                notHandled.addSuppressed(e);
                request.requestCompleted(notHandled);
                throw notHandled;
            }
        }
        request.requestCompleted(null);
    }

    public void setHandlerMapping(HandlerMapping handlerMapping) {
        Assert.notNull((Object)handlerMapping, (String)"HandlerMapping is required");
        this.handlerMapping = handlerMapping;
    }

    public void setHandlerAdapter(HandlerAdapter handlerAdapter) {
        Assert.notNull((Object)handlerAdapter, (String)"HandlerAdapter is required");
        this.handlerAdapter = handlerAdapter;
    }

    public void setExceptionHandler(HandlerExceptionHandler exceptionHandler) {
        Assert.notNull((Object)exceptionHandler, (String)"exceptionHandler is required");
        this.exceptionHandler = exceptionHandler;
    }

    public void setReturnValueHandler(ReturnValueHandlerManager returnValueHandler) {
        Assert.notNull((Object)returnValueHandler, (String)"ReturnValueHandlerManager is required");
        this.returnValueHandler = returnValueHandler;
    }

    public void setDetectAllHandlerMapping(boolean detectAllHandlerMapping) {
        this.detectAllHandlerMapping = detectAllHandlerMapping;
    }

    public void setDetectAllHandlerAdapters(boolean detectAllHandlerAdapters) {
        this.detectAllHandlerAdapters = detectAllHandlerAdapters;
    }

    public void setDetectAllHandlerExceptionHandlers(boolean detectAllHandlerExceptionHandlers) {
        this.detectAllHandlerExceptionHandlers = detectAllHandlerExceptionHandlers;
    }

    public void setThrowExceptionIfNoHandlerFound(boolean throwExceptionIfNoHandlerFound) {
        this.throwExceptionIfNoHandlerFound = throwExceptionIfNoHandlerFound;
    }

    public void setNotFoundHandler(NotFoundHandler notFoundHandler) {
        Assert.notNull((Object)notFoundHandler, (String)"NotFoundHandler is required");
        this.notFoundHandler = notFoundHandler;
    }

    public void setWebAsyncManagerFactory(WebAsyncManagerFactory factory) {
        Assert.notNull((Object)factory, (String)"WebAsyncManagerFactory is required");
        this.webAsyncManagerFactory = factory;
    }

    public void addRequestCompletedActions(RequestCompletedListener ... array) {
        this.requestCompletedActions.add((Object[])array);
    }

    public void addRequestCompletedActions(@Nullable Collection<RequestCompletedListener> list) {
        this.requestCompletedActions.addAll(list);
    }

    public void setRequestCompletedActions(@Nullable Collection<RequestCompletedListener> list) {
        this.requestCompletedActions.set(list);
    }

    private void logRequest(RequestContext request) {
        if (log.isDebugEnabled()) {
            String contentType = request.getContentType();
            String params = StringUtils.startsWithIgnoreCase((String)contentType, (String)"multipart/") ? "multipart" : (this.isEnableLoggingRequestDetails() ? request.getParameters().entrySet().stream().map(entry -> (String)entry.getKey() + ":" + entry.getValue()).collect(Collectors.joining(", ")) : (StringUtils.startsWithIgnoreCase((String)contentType, (String)"application/x-www-form-urlencoded") || !request.getParameters().isEmpty() ? "masked" : ""));
            String queryString = request.getQueryString();
            Object queryClause = StringUtils.isNotEmpty((CharSequence)queryString) ? "?" + queryString : "";
            Object message = request.getMethod() + " " + request.getRequestURL() + (String)queryClause;
            if (!params.isEmpty()) {
                message = (String)message + ", parameters={%s}".formatted(params);
            }
            message = URLDecoder.decode((String)message, StandardCharsets.UTF_8);
            if (log.isTraceEnabled()) {
                StringBuilder headers = new StringBuilder();
                HttpHeaders httpHeaders = request.requestHeaders();
                if (!httpHeaders.isEmpty()) {
                    if (this.isEnableLoggingRequestDetails()) {
                        Iterator headerNames = httpHeaders.keySet().iterator();
                        if (headerNames.hasNext()) {
                            String name = (String)headerNames.next();
                            headers.append(name).append(':').append(httpHeaders.getValuesAsList(name));
                            while (headerNames.hasNext()) {
                                name = (String)headerNames.next();
                                headers.append(", ");
                                headers.append(name);
                                headers.append(':');
                                headers.append(httpHeaders.get(name));
                            }
                        }
                    } else {
                        headers.append("masked");
                    }
                }
                log.trace("%s, headers={%s} in DispatcherHandler '%s'".formatted(message, headers, this.beanName));
            } else {
                log.debug((String)message);
            }
        }
    }

    private void logResult(RequestContext request, @Nullable Throwable failureCause) {
        if (log.isDebugEnabled()) {
            if (failureCause != null) {
                if (log.isTraceEnabled()) {
                    log.trace("Failed to complete request", failureCause);
                } else {
                    log.debug("Failed to complete request", failureCause);
                }
            } else {
                if (request.isConcurrentHandlingStarted()) {
                    log.debug("Exiting but response remains open for further handling");
                    return;
                }
                String headers = "";
                if (log.isTraceEnabled()) {
                    HttpHeaders httpHeaders = request.responseHeaders();
                    headers = this.isEnableLoggingRequestDetails() ? httpHeaders.entrySet().stream().map(entry -> (String)entry.getKey() + ":" + entry.getValue()).collect(Collectors.joining(", ")) : (httpHeaders.isEmpty() ? "" : "masked");
                    headers = ", headers={%s}".formatted(headers);
                }
                HttpStatus httpStatus = HttpStatus.resolve(request.getStatus());
                log.debug("{} Completed {}{}", new Object[]{request, httpStatus != null ? httpStatus : Integer.valueOf(request.getStatus()), headers});
            }
        }
    }

    private void logStrategy(Object strategy) {
        if (log.isDebugEnabled()) {
            log.debug("Detected {}", (Object)strategy.getClass().getName());
        }
    }
}

