/*
 * Decompiled with CFR 0.152.
 */
package infra.web;

import infra.context.ApplicationContext;
import infra.lang.Assert;
import infra.lang.Nullable;
import infra.web.RequestContext;
import infra.web.RequestContextDecorator;
import java.util.HashSet;
import java.util.Set;

public class ContextExposingRequestContext
extends RequestContextDecorator {
    private final ApplicationContext webApplicationContext;
    @Nullable
    private final Set<String> exposedContextBeanNames;
    @Nullable
    private Set<String> explicitAttributes;

    public ContextExposingRequestContext(RequestContext originalRequest, ApplicationContext context, @Nullable Set<String> exposedContextBeanNames) {
        super(originalRequest);
        Assert.notNull((Object)context, (String)"WebApplicationContext is required");
        this.webApplicationContext = context;
        this.exposedContextBeanNames = exposedContextBeanNames;
    }

    @Override
    public ApplicationContext getApplicationContext() {
        return this.webApplicationContext;
    }

    @Override
    @Nullable
    public Object getAttribute(String name) {
        if (!(this.explicitAttributes != null && this.explicitAttributes.contains(name) || this.exposedContextBeanNames != null && !this.exposedContextBeanNames.contains(name) || !this.webApplicationContext.containsBean(name))) {
            return this.webApplicationContext.getBean(name);
        }
        return super.getAttribute(name);
    }

    @Override
    public void setAttribute(String name, Object value) {
        super.setAttribute(name, value);
        if (this.explicitAttributes == null) {
            this.explicitAttributes = new HashSet<String>(8);
        }
        this.explicitAttributes.add(name);
    }
}

