/*
 * Decompiled with CFR 0.152.
 */
package infra.web;

import infra.core.ResolvableType;
import infra.lang.Nullable;
import infra.ui.ModelMap;
import infra.web.RedirectModel;
import infra.web.RequestContext;
import infra.web.bind.WebDataBinder;
import infra.web.bind.support.BindParamNameResolver;
import infra.web.bind.support.WebBindingInitializer;
import infra.web.view.BindingAwareModelMap;
import infra.web.view.ModelAndView;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class BindingContext {
    @Nullable
    private ModelMap model;
    @Nullable
    private RedirectModel redirectModel;
    @Nullable
    private Set<String> noBinding;
    @Nullable
    private Set<String> bindingDisabled;
    @Nullable
    private final WebBindingInitializer initializer;
    @Nullable
    protected ModelAndView modelAndView;

    public BindingContext() {
        this(null);
    }

    public BindingContext(@Nullable WebBindingInitializer initializer) {
        this.initializer = initializer;
    }

    public WebDataBinder createBinder(RequestContext context, String objectName) throws Throwable {
        return this.createBinder(context, null, objectName, null);
    }

    public WebDataBinder createBinder(RequestContext request, @Nullable Object target, String objectName) throws Throwable {
        return this.createBinder(request, target, objectName, null);
    }

    public WebDataBinder createBinder(RequestContext request, @Nullable Object target, String objectName, @Nullable ResolvableType targetType) throws Throwable {
        WebDataBinder dataBinder = this.createBinderInstance(target, objectName, request);
        dataBinder.setNameResolver(new BindParamNameResolver());
        if (target == null && targetType != null) {
            dataBinder.setTargetType(targetType);
        }
        if (this.initializer != null) {
            this.initializer.initBinder(dataBinder);
        }
        this.initBinder(dataBinder, request);
        return dataBinder;
    }

    protected WebDataBinder createBinderInstance(@Nullable Object target, String objectName, RequestContext request) throws Exception {
        return new WebDataBinder(target, objectName);
    }

    public void initBinder(WebDataBinder dataBinder, RequestContext request) throws Throwable {
    }

    public ModelAndView getModelAndView() {
        if (this.modelAndView == null) {
            this.modelAndView = new ModelAndView();
        }
        return this.modelAndView;
    }

    public boolean hasModelAndView() {
        return this.modelAndView != null;
    }

    public boolean hasModel() {
        return this.model != null;
    }

    public ModelMap getModel() {
        ModelMap model = this.model;
        if (model == null) {
            this.model = model = new BindingAwareModelMap();
        }
        return model;
    }

    public void updateModel(RequestContext request) throws Throwable {
    }

    public void initModel(RequestContext request) throws Throwable {
    }

    @Nullable
    public RedirectModel getRedirectModel() {
        return this.redirectModel;
    }

    public void setRedirectModel(@Nullable RedirectModel redirectModel) {
        this.redirectModel = redirectModel;
    }

    public void setBindingDisabled(String attributeName) {
        if (this.bindingDisabled == null) {
            this.bindingDisabled = new HashSet<String>(4);
        }
        this.bindingDisabled.add(attributeName);
    }

    public boolean isBindingDisabled(String name) {
        if (this.bindingDisabled != null) {
            if (this.noBinding != null) {
                return this.bindingDisabled.contains(name) || this.noBinding.contains(name);
            }
            return this.bindingDisabled.contains(name);
        }
        if (this.noBinding != null) {
            return this.noBinding.contains(name);
        }
        return false;
    }

    public void setBinding(String attributeName, boolean enabled) {
        if (this.noBinding == null) {
            this.noBinding = new HashSet<String>(4);
        }
        if (!enabled) {
            this.noBinding.add(attributeName);
        } else {
            this.noBinding.remove(attributeName);
        }
    }

    public BindingContext addAttribute(String name, @Nullable Object value) {
        this.getModel().addAttribute(name, value);
        return this;
    }

    public BindingContext addAttribute(Object value) {
        this.getModel().addAttribute(value);
        return this;
    }

    public BindingContext addAllAttributes(@Nullable Map<String, ?> attributes) {
        if (attributes != null) {
            this.getModel().addAllAttributes(attributes);
        }
        return this;
    }

    public BindingContext mergeAttributes(@Nullable Map<String, ?> attributes) {
        if (attributes != null) {
            this.getModel().mergeAttributes(attributes);
        }
        return this;
    }

    public BindingContext removeAttributes(@Nullable Map<String, ?> attributes) {
        if (attributes != null && this.hasModel()) {
            ModelMap modelMap = this.getModel();
            for (String key : attributes.keySet()) {
                modelMap.removeAttribute(key);
            }
        }
        return this;
    }

    public boolean containsAttribute(String name) {
        return this.hasModel() && this.getModel().containsAttribute(name);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("BindingContext: model: ");
        sb.append(this.model);
        RedirectModel redirectModel = this.getRedirectModel();
        if (redirectModel != null) {
            sb.append("; redirect model ");
            sb.append(redirectModel);
        }
        return sb.toString();
    }
}

