/*
 * Decompiled with CFR 0.152.
 */
package infra.web;

import infra.lang.Nullable;
import infra.logging.Logger;
import infra.logging.LoggerFactory;
import infra.util.CollectionUtils;
import infra.util.MultiValueMap;
import infra.util.StringUtils;
import infra.web.RedirectModel;
import infra.web.RedirectModelManager;
import infra.web.RequestContext;
import infra.web.util.UriComponentsBuilder;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;

public abstract class AbstractRedirectModelManager
implements RedirectModelManager {
    protected static final Object DEFAULT_FLASH_MAPS_MUTEX = new Object();
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private int redirectModelTimeout = 180;

    public void setRedirectModelTimeout(int redirectModelTimeout) {
        this.redirectModelTimeout = redirectModelTimeout;
    }

    public int getRedirectModelTimeout() {
        return this.redirectModelTimeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public RedirectModel retrieveAndUpdate(RequestContext context) {
        List<RedirectModel> allRedirectModels = this.retrieveRedirectModel(context);
        if (CollectionUtils.isEmpty(allRedirectModels)) {
            return null;
        }
        List<RedirectModel> mapsToRemove = this.getExpired(allRedirectModels);
        RedirectModel match = this.getMatchingRedirectModel(allRedirectModels, context);
        if (match != null) {
            mapsToRemove.add(match);
        }
        if (!mapsToRemove.isEmpty()) {
            Object mutex = this.getRedirectModelMutex(context);
            if (mutex != null) {
                Object object = mutex;
                synchronized (object) {
                    allRedirectModels = this.retrieveRedirectModel(context);
                    if (allRedirectModels != null) {
                        allRedirectModels.removeAll(mapsToRemove);
                        this.updateRedirectModel(allRedirectModels, context);
                    }
                }
            } else {
                allRedirectModels.removeAll(mapsToRemove);
                this.updateRedirectModel(allRedirectModels, context);
            }
        }
        return match;
    }

    private List<RedirectModel> getExpired(List<RedirectModel> allMaps) {
        ArrayList<RedirectModel> result = new ArrayList<RedirectModel>();
        for (RedirectModel map : allMaps) {
            if (!map.isExpired()) continue;
            result.add(map);
        }
        return result;
    }

    @Nullable
    private RedirectModel getMatchingRedirectModel(List<RedirectModel> allMaps, RequestContext request) {
        ArrayList<RedirectModel> result = new ArrayList<RedirectModel>();
        for (RedirectModel model : allMaps) {
            if (!this.isRedirectModelForRequest(model, request)) continue;
            result.add(model);
        }
        if (!result.isEmpty()) {
            Collections.sort(result);
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("Found {}", result.get(0));
            }
            return (RedirectModel)result.get(0);
        }
        return null;
    }

    protected boolean isRedirectModelForRequest(RedirectModel model, RequestContext request) {
        String requestUri;
        String expectedPath = model.getTargetRequestPath();
        if (expectedPath != null && !(requestUri = request.getRequestURI()).equals(expectedPath) && !requestUri.equals(expectedPath + "/")) {
            return false;
        }
        MultiValueMap<String, String> actualParams = this.getOriginatingRequestParams(request);
        MultiValueMap<String, String> expectedParams = model.getTargetRequestParams();
        for (Map.Entry entry : expectedParams.entrySet()) {
            List actualValues = (List)actualParams.get(entry.getKey());
            if (actualValues == null) {
                return false;
            }
            for (String expectedValue : (List)entry.getValue()) {
                if (actualValues.contains(expectedValue)) continue;
                return false;
            }
        }
        return true;
    }

    private MultiValueMap<String, String> getOriginatingRequestParams(RequestContext request) {
        String query = request.getQueryString();
        return UriComponentsBuilder.fromPath("/").query(query).build().getQueryParams();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void saveRedirectModel(RequestContext context, @Nullable RedirectModel redirectModel) {
        if (CollectionUtils.isEmpty((Map)((Object)redirectModel))) {
            return;
        }
        String path = this.decodeAndNormalizePath(redirectModel.getTargetRequestPath(), context);
        redirectModel.setTargetRequestPath(path);
        redirectModel.startExpirationPeriod(this.getRedirectModelTimeout());
        Object mutex = this.getRedirectModelMutex(context);
        if (mutex != null) {
            Object object = mutex;
            synchronized (object) {
                CopyOnWriteArrayList<RedirectModel> allRedirectModels = this.retrieveRedirectModel(context);
                allRedirectModels = allRedirectModels != null ? allRedirectModels : new CopyOnWriteArrayList<RedirectModel>();
                allRedirectModels.add(redirectModel);
                this.updateRedirectModel(allRedirectModels, context);
            }
        } else {
            ArrayList<RedirectModel> allRedirectModels = this.retrieveRedirectModel(context);
            allRedirectModels = allRedirectModels != null ? allRedirectModels : new ArrayList<RedirectModel>(1);
            allRedirectModels.add(redirectModel);
            this.updateRedirectModel(allRedirectModels, context);
        }
    }

    @Nullable
    private String decodeAndNormalizePath(@Nullable String path, RequestContext request) {
        if (path != null && !((String)path).isEmpty() && ((String)(path = URLDecoder.decode((String)path, StandardCharsets.UTF_8))).charAt(0) != '/') {
            String requestUri = request.getRequestURI();
            path = requestUri.substring(0, requestUri.lastIndexOf(47) + 1) + (String)path;
            path = StringUtils.cleanPath((String)path);
        }
        return path;
    }

    @Nullable
    protected abstract List<RedirectModel> retrieveRedirectModel(RequestContext var1);

    protected abstract void updateRedirectModel(List<RedirectModel> var1, RequestContext var2);

    @Nullable
    protected Object getRedirectModelMutex(RequestContext request) {
        return DEFAULT_FLASH_MAPS_MUTEX;
    }
}

