/*
 * Decompiled with CFR 0.152.
 */
package infra.session.config;

import infra.beans.factory.SmartInitializingSingleton;
import infra.beans.factory.annotation.DisableAllDependencyInjection;
import infra.beans.factory.annotation.DisableDependencyInjection;
import infra.beans.factory.config.ConfigurableBeanFactory;
import infra.beans.factory.support.MergedBeanDefinitionPostProcessor;
import infra.beans.factory.support.RootBeanDefinition;
import infra.context.annotation.Configuration;
import infra.context.annotation.MissingBean;
import infra.context.annotation.Role;
import infra.context.condition.ConditionalOnMissingBean;
import infra.context.properties.EnableConfigurationProperties;
import infra.core.ApplicationTemp;
import infra.lang.Nullable;
import infra.session.CookieSessionIdResolver;
import infra.session.DefaultSessionManager;
import infra.session.FileSessionPersister;
import infra.session.InMemorySessionRepository;
import infra.session.PersistenceSessionRepository;
import infra.session.SecureRandomSessionIdGenerator;
import infra.session.SessionEventDispatcher;
import infra.session.SessionIdGenerator;
import infra.session.SessionIdResolver;
import infra.session.SessionManager;
import infra.session.SessionMethodArgumentResolver;
import infra.session.SessionPersister;
import infra.session.SessionRedirectModelManager;
import infra.session.SessionRepository;
import infra.session.WebSessionAttributeListener;
import infra.session.WebSessionAttributeParameterResolver;
import infra.session.WebSessionListener;
import infra.session.config.SessionProperties;
import infra.stereotype.Component;
import infra.web.RedirectModelManager;
import infra.web.context.support.SessionScope;
import java.io.File;

@DisableDependencyInjection
@DisableAllDependencyInjection
@Configuration(proxyBeanMethods=false)
@EnableConfigurationProperties(value={SessionProperties.class})
class WebSessionConfiguration
implements MergedBeanDefinitionPostProcessor,
SmartInitializingSingleton {
    volatile boolean destructionCallbackRegistered;

    WebSessionConfiguration() {
    }

    public synchronized void postProcessMergedBeanDefinition(RootBeanDefinition beanDefinition, Class<?> bean, String beanName) {
        if (!this.destructionCallbackRegistered && "session".equals(beanDefinition.getScope())) {
            this.destructionCallbackRegistered = true;
        }
    }

    @Component(value={"webSessionManager"})
    @Role(value=2)
    @ConditionalOnMissingBean(value={SessionManager.class}, name={"webSessionManager"})
    static DefaultSessionManager webSessionManager(SessionIdResolver sessionIdResolver, SessionRepository repository) {
        return new DefaultSessionManager(repository, sessionIdResolver);
    }

    @MissingBean
    @Role(value=2)
    static SessionEventDispatcher sessionEventDispatcher() {
        return new SessionEventDispatcher();
    }

    @Component
    @Role(value=2)
    static WebSessionAttributeParameterResolver webSessionAttributeMethodArgumentResolver(SessionManager sessionManager, ConfigurableBeanFactory beanFactory) {
        return new WebSessionAttributeParameterResolver(sessionManager, beanFactory);
    }

    @Component
    @Role(value=2)
    static SessionMethodArgumentResolver webSessionMethodArgumentResolver(SessionManager sessionManager) {
        return new SessionMethodArgumentResolver(sessionManager);
    }

    @Component
    @Role(value=2)
    @ConditionalOnMissingBean(value={SessionRepository.class})
    static SessionRepository sessionRepository(SessionProperties properties, SessionEventDispatcher eventDispatcher, SessionIdGenerator idGenerator, @Nullable SessionPersister sessionPersister, @Nullable ApplicationTemp applicationTemp) {
        InMemorySessionRepository repository = new InMemorySessionRepository(eventDispatcher, idGenerator);
        repository.setMaxSessions(properties.getMaxSessions());
        repository.setSessionMaxIdleTime(properties.getTimeout());
        if (properties.isPersistent() || sessionPersister != null) {
            if (sessionPersister == null) {
                FileSessionPersister filePersister = new FileSessionPersister(repository);
                File validDirectory = properties.getValidStoreDir(applicationTemp);
                filePersister.setDirectory(validDirectory);
                filePersister.setApplicationTemp(applicationTemp);
                sessionPersister = filePersister;
            }
            return new PersistenceSessionRepository(sessionPersister, repository);
        }
        return repository;
    }

    @Component
    @Role(value=2)
    @ConditionalOnMissingBean(value={SessionIdGenerator.class})
    static SessionIdGenerator sessionIdGenerator(SessionProperties sessionProperties) {
        SecureRandomSessionIdGenerator generator = new SecureRandomSessionIdGenerator();
        generator.setSessionIdLength(sessionProperties.getSessionIdLength());
        return generator;
    }

    @Component
    @Role(value=2)
    @ConditionalOnMissingBean(value={SessionIdResolver.class})
    static CookieSessionIdResolver cookieSessionIdResolver(SessionProperties sessionProperties) {
        return new CookieSessionIdResolver(sessionProperties.cookie);
    }

    @Component(value={"redirectModelManager"})
    @Role(value=2)
    @ConditionalOnMissingBean(value={RedirectModelManager.class}, name={"redirectModelManager"})
    static SessionRedirectModelManager sessionRedirectModelManager(SessionManager sessionManager) {
        return new SessionRedirectModelManager(sessionManager);
    }

    public void afterSingletonsInstantiated(ConfigurableBeanFactory beanFactory) {
        SessionRepository sessionRepository;
        SessionEventDispatcher eventDispatcher = (SessionEventDispatcher)beanFactory.getBean(SessionEventDispatcher.class);
        eventDispatcher.addSessionListeners(beanFactory.getBeanProvider(WebSessionListener.class).orderedList());
        eventDispatcher.addAttributeListeners(beanFactory.getBeanProvider(WebSessionAttributeListener.class).orderedList());
        if (this.destructionCallbackRegistered) {
            eventDispatcher.addAttributeListeners(SessionScope.createDestructionCallback());
        }
        if ((sessionRepository = (SessionRepository)beanFactory.getBean(SessionRepository.class)) instanceof PersistenceSessionRepository) {
            PersistenceSessionRepository repository = (PersistenceSessionRepository)sessionRepository;
            eventDispatcher.addSessionListeners(repository.createDestructionCallback());
        }
    }
}

