/*
 * Decompiled with CFR 0.152.
 */
package infra.session.config;

import infra.context.properties.ConfigurationProperties;
import infra.context.properties.NestedConfigurationProperty;
import infra.core.ApplicationHome;
import infra.core.ApplicationTemp;
import infra.format.annotation.DurationUnit;
import infra.lang.Assert;
import infra.lang.Nullable;
import infra.lang.TodayStrategies;
import infra.session.config.CookieProperties;
import java.io.File;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.Objects;

@ConfigurationProperties(prefix="server.session", ignoreUnknownFields=true)
public class SessionProperties {
    private static final String SESSION_TEMP_DIR = TodayStrategies.getProperty((String)"server.session.temp-dir", (String)"server-sessions");
    @Nullable
    @DurationUnit(value=ChronoUnit.SECONDS)
    private Duration timeout = Duration.ofMinutes(30L);
    private boolean persistent;
    @Nullable
    private File storeDir;
    @NestedConfigurationProperty
    public final CookieProperties cookie = new CookieProperties();
    private int sessionIdLength = 32;
    private int maxSessions = 10000;

    public void setMaxSessions(int maxSessions) {
        this.maxSessions = maxSessions;
    }

    public int getMaxSessions() {
        return this.maxSessions;
    }

    public void setSessionIdLength(int sessionIdLength) {
        Assert.isTrue((sessionIdLength > 0 ? 1 : 0) != 0, (String)"Session id length must > 0");
        this.sessionIdLength = sessionIdLength;
    }

    public int getSessionIdLength() {
        return this.sessionIdLength;
    }

    @Nullable
    public Duration getTimeout() {
        return this.timeout;
    }

    public void setTimeout(@Nullable Duration timeout) {
        this.timeout = timeout;
    }

    public boolean isPersistent() {
        return this.persistent;
    }

    public void setPersistent(boolean persistent) {
        this.persistent = persistent;
    }

    @Nullable
    public File getStoreDir() {
        return this.storeDir;
    }

    public void setStoreDir(@Nullable File storeDir) {
        this.storeDir = storeDir;
    }

    public File getValidStoreDir(@Nullable ApplicationTemp applicationTemp) {
        return this.getValidStoreDir(applicationTemp, true);
    }

    public File getValidStoreDir(@Nullable ApplicationTemp applicationTemp, boolean mkdirs) {
        return SessionProperties.getValidStoreDir(applicationTemp, this.storeDir, mkdirs);
    }

    public static File getValidStoreDir(@Nullable ApplicationTemp applicationTemp, @Nullable File dir, boolean mkdirs) {
        if (dir == null) {
            return Objects.requireNonNullElse(applicationTemp, ApplicationTemp.instance).getDir(SESSION_TEMP_DIR).toFile();
        }
        if (!dir.isAbsolute()) {
            dir = new File(new ApplicationHome().getDir(), dir.getPath());
        }
        if (!dir.exists() && mkdirs) {
            dir.mkdirs();
        }
        SessionProperties.assertDirectory(mkdirs, dir);
        return dir;
    }

    private static void assertDirectory(boolean mkdirs, File dir) {
        if (mkdirs && !dir.exists()) {
            throw new IllegalStateException("Session dir %s does not exist".formatted(dir));
        }
        if (dir.isFile()) {
            throw new IllegalStateException("Session dir %s points to a file".formatted(dir));
        }
    }
}

