/*
 * Decompiled with CFR 0.152.
 */
package infra.session.config;

import infra.format.annotation.DurationUnit;
import infra.http.ResponseCookie;
import infra.lang.Nullable;
import infra.session.config.SameSite;
import java.time.Duration;
import java.time.temporal.ChronoUnit;

public class CookieProperties {
    public static final String DEFAULT_COOKIE_NAME = "SESSION";
    private String name = "SESSION";
    private String domain;
    private String path;
    @Nullable
    private Boolean httpOnly;
    @Nullable
    private Boolean secure;
    @DurationUnit(value=ChronoUnit.SECONDS)
    private Duration maxAge = Duration.ofMinutes(30L);
    private SameSite sameSite;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDomain() {
        return this.domain;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    @Nullable
    public Boolean getHttpOnly() {
        return this.httpOnly;
    }

    public void setHttpOnly(@Nullable Boolean httpOnly) {
        this.httpOnly = httpOnly;
    }

    @Nullable
    public Boolean getSecure() {
        return this.secure;
    }

    public void setSecure(@Nullable Boolean secure) {
        this.secure = secure;
    }

    public Duration getMaxAge() {
        return this.maxAge;
    }

    public void setMaxAge(Duration maxAge) {
        this.maxAge = maxAge;
    }

    public SameSite getSameSite() {
        return this.sameSite;
    }

    public void setSameSite(SameSite sameSite) {
        this.sameSite = sameSite;
    }

    public ResponseCookie createCookie(String value) {
        return ResponseCookie.from(this.name, value).path(this.path).domain(this.domain).secure(Boolean.TRUE.equals(this.secure)).httpOnly(Boolean.TRUE.equals(this.httpOnly)).maxAge(this.maxAge).build();
    }
}

