/*
 * Decompiled with CFR 0.152.
 */
package infra.session;

import infra.beans.factory.config.ConfigurableBeanFactory;
import infra.lang.Assert;
import infra.lang.Nullable;
import infra.session.SessionManager;
import infra.session.WebSession;
import infra.web.RequestContext;
import infra.web.annotation.SessionAttribute;
import infra.web.bind.resolver.AbstractNamedValueResolvingStrategy;
import infra.web.handler.method.ResolvableMethodParameter;

public class WebSessionAttributeParameterResolver
extends AbstractNamedValueResolvingStrategy {
    private final SessionManager sessionManager;

    public WebSessionAttributeParameterResolver(SessionManager sessionManager, @Nullable ConfigurableBeanFactory beanFactory) {
        super(beanFactory);
        Assert.notNull((Object)sessionManager, (String)"sessionManager is required");
        this.sessionManager = sessionManager;
    }

    @Override
    public boolean supportsParameter(ResolvableMethodParameter parameter) {
        return parameter.hasParameterAnnotation(SessionAttribute.class);
    }

    @Override
    @Nullable
    protected Object resolveName(String name, ResolvableMethodParameter resolvable, RequestContext context) throws Exception {
        WebSession session = this.sessionManager.getSession(context, false);
        if (session == null) {
            return null;
        }
        return session.getAttribute(name);
    }
}

