/*
 * Decompiled with CFR 0.152.
 */
package infra.session;

import infra.lang.Assert;
import infra.lang.Nullable;
import infra.session.SessionManager;
import infra.session.WebSession;
import infra.util.CollectionUtils;
import infra.web.AbstractRedirectModelManager;
import infra.web.RedirectModel;
import infra.web.RedirectModelManager;
import infra.web.RequestContext;
import infra.web.RequestContextUtils;
import infra.web.util.WebUtils;
import java.util.List;

public class SessionRedirectModelManager
extends AbstractRedirectModelManager
implements RedirectModelManager {
    private static final String SESSION_ATTRIBUTE = SessionRedirectModelManager.class.getName() + ".RedirectModel";
    @Nullable
    private SessionManager sessionManager;

    public SessionRedirectModelManager() {
    }

    public SessionRedirectModelManager(@Nullable SessionManager sessionManager) {
        this.sessionManager = sessionManager;
    }

    @Override
    @Nullable
    protected List<RedirectModel> retrieveRedirectModel(RequestContext request) {
        WebSession session = this.getSession(request, false);
        if (session != null) {
            return (List)session.getAttribute(SESSION_ATTRIBUTE);
        }
        return null;
    }

    @Override
    protected void updateRedirectModel(List<RedirectModel> redirectModels, RequestContext request) {
        if (CollectionUtils.isEmpty(redirectModels)) {
            WebSession session = this.getSession(request, false);
            if (session != null) {
                session.removeAttribute(SESSION_ATTRIBUTE);
            }
        } else {
            WebSession session = this.getSession(request, true);
            Assert.state((session != null ? 1 : 0) != 0, (String)"WebSession not found in current request");
            session.setAttribute(SESSION_ATTRIBUTE, redirectModels);
        }
    }

    @Override
    @Nullable
    protected Object getRedirectModelMutex(RequestContext request) {
        WebSession session = this.getSession(request, false);
        if (session != null) {
            return WebUtils.getSessionMutex(session);
        }
        return null;
    }

    @Nullable
    public SessionManager getSessionManager() {
        return this.sessionManager;
    }

    @Nullable
    private WebSession getSession(RequestContext context, boolean create) {
        SessionManager sessionManager = this.getSessionManager();
        if (sessionManager == null) {
            return RequestContextUtils.getSession(context, create);
        }
        return sessionManager.getSession(context, create);
    }
}

