/*
 * Decompiled with CFR 0.152.
 */
package infra.session;

import infra.lang.Assert;
import infra.lang.Nullable;
import infra.session.SessionManager;
import infra.session.WebSession;
import infra.web.RequestContext;

public class SessionManagerOperations {
    private final SessionManager sessionManager;

    public SessionManagerOperations(SessionManager sessionManager) {
        Assert.notNull((Object)sessionManager, (String)"SessionManager is required");
        this.sessionManager = sessionManager;
    }

    public final SessionManager getSessionManager() {
        return this.sessionManager;
    }

    public WebSession getSession(RequestContext context) {
        return this.sessionManager.getSession(context);
    }

    @Nullable
    public WebSession getSession(RequestContext context, boolean create) {
        return this.sessionManager.getSession(context, create);
    }

    @Nullable
    public Object getAttribute(WebSession session, String name) {
        return session.getAttribute(name);
    }

    @Nullable
    public Object getAttribute(RequestContext context, String name) {
        WebSession session = this.getSession(context, false);
        if (session != null) {
            return this.getAttribute(session, name);
        }
        return null;
    }

    public void setAttribute(RequestContext context, String name, @Nullable Object attribute) {
        WebSession session = this.getSession(context, false);
        if (session != null) {
            session.setAttribute(name, attribute);
        }
    }

    @Nullable
    public Object removeAttribute(RequestContext context, String name) {
        WebSession session = this.getSession(context, false);
        if (session != null) {
            return session.removeAttribute(name);
        }
        return null;
    }
}

