/*
 * Decompiled with CFR 0.152.
 */
package infra.session;

import infra.core.Conventions;
import infra.lang.Nullable;
import infra.session.CookieSessionIdResolver;
import infra.session.HeaderSessionIdResolver;
import infra.session.RequestParameterSessionIdResolver;
import infra.session.config.CookieProperties;
import infra.web.RequestContext;
import java.util.List;

public interface SessionIdResolver {
    public static final String WRITTEN_SESSION_ID_ATTR = Conventions.getQualifiedAttributeName(CookieSessionIdResolver.class, (String)"WRITTEN_SESSION_ID_ATTR");
    public static final String HEADER_X_AUTH_TOKEN = "X-Auth-Token";
    public static final String HEADER_AUTHENTICATION_INFO = "Authentication-Info";

    @Nullable
    public String getSessionId(RequestContext var1);

    public void setSessionId(RequestContext var1, String var2);

    public void expireSession(RequestContext var1);

    public static HeaderSessionIdResolver xAuthToken() {
        return SessionIdResolver.forHeader(HEADER_X_AUTH_TOKEN);
    }

    public static HeaderSessionIdResolver authenticationInfo() {
        return SessionIdResolver.forHeader(HEADER_AUTHENTICATION_INFO);
    }

    public static HeaderSessionIdResolver forHeader(String headerName) {
        return new HeaderSessionIdResolver(headerName);
    }

    public static RequestParameterSessionIdResolver forParameter(String parameterName) {
        return new RequestParameterSessionIdResolver(parameterName);
    }

    public static CookieSessionIdResolver forCookie(String cookieName) {
        return new CookieSessionIdResolver(cookieName);
    }

    public static CookieSessionIdResolver forCookie(CookieProperties properties) {
        return new CookieSessionIdResolver(properties);
    }

    public static SessionIdResolver forComposite(SessionIdResolver ... resolvers) {
        return new Composite(List.of(resolvers));
    }

    public static SessionIdResolver forComposite(List<SessionIdResolver> resolvers) {
        return new Composite(resolvers);
    }

    public static final class Composite
    implements SessionIdResolver {
        final List<SessionIdResolver> resolvers;

        public Composite(List<SessionIdResolver> resolvers) {
            this.resolvers = resolvers;
        }

        @Override
        public String getSessionId(RequestContext exchange) {
            for (SessionIdResolver resolver : this.resolvers) {
                String token = resolver.getSessionId(exchange);
                if (token == null) continue;
                return token;
            }
            return null;
        }

        @Override
        public void setSessionId(RequestContext exchange, String session) {
            for (SessionIdResolver resolver : this.resolvers) {
                resolver.setSessionId(exchange, session);
            }
        }

        @Override
        public void expireSession(RequestContext context) {
            for (SessionIdResolver resolver : this.resolvers) {
                String token = resolver.getSessionId(context);
                if (token == null) continue;
                resolver.expireSession(context);
            }
        }
    }
}

