/*
 * Decompiled with CFR 0.152.
 */
package infra.session;

import infra.lang.Nullable;
import infra.session.WebSession;
import infra.session.WebSessionAttributeListener;
import infra.session.WebSessionEvent;
import infra.session.WebSessionListener;
import infra.util.ArrayHolder;
import java.util.Collection;

public class SessionEventDispatcher {
    private final ArrayHolder<WebSessionListener> sessionListeners = ArrayHolder.forGenerator(WebSessionListener[]::new);
    private final ArrayHolder<WebSessionAttributeListener> attributeListeners = ArrayHolder.forGenerator(WebSessionAttributeListener[]::new);

    public void onSessionCreated(WebSession session) {
        WebSessionEvent event = new WebSessionEvent(this, session);
        for (WebSessionListener listener : this.sessionListeners) {
            listener.sessionCreated(event);
        }
    }

    public void onSessionDestroyed(WebSession session) {
        WebSessionEvent event = new WebSessionEvent(this, session);
        for (WebSessionListener listener : this.sessionListeners) {
            listener.sessionDestroyed(event);
        }
    }

    public void attributeAdded(WebSession session, String attributeName, Object value) {
        for (WebSessionAttributeListener listener : this.attributeListeners) {
            listener.attributeAdded(session, attributeName, value);
        }
    }

    public void attributeRemoved(WebSession session, String attributeName, @Nullable Object value) {
        for (WebSessionAttributeListener listener : this.attributeListeners) {
            listener.attributeRemoved(session, attributeName, value);
        }
    }

    public void attributeReplaced(WebSession session, String attributeName, Object oldValue, Object newValue) {
        for (WebSessionAttributeListener listener : this.attributeListeners) {
            listener.attributeReplaced(session, attributeName, oldValue, newValue);
        }
    }

    public void addAttributeListeners(WebSessionAttributeListener ... array) {
        this.attributeListeners.add((Object[])array);
    }

    public void addAttributeListeners(@Nullable Collection<WebSessionAttributeListener> list) {
        this.attributeListeners.addAll(list);
    }

    public void addSessionListeners(WebSessionListener ... array) {
        this.sessionListeners.add((Object[])array);
    }

    public void addSessionListeners(@Nullable Collection<WebSessionListener> list) {
        this.sessionListeners.addAll(list);
    }

    public ArrayHolder<WebSessionAttributeListener> getAttributeListeners() {
        return this.attributeListeners;
    }

    public ArrayHolder<WebSessionListener> getSessionListeners() {
        return this.sessionListeners;
    }
}

