/*
 * Decompiled with CFR 0.152.
 */
package infra.session;

import infra.lang.Assert;
import infra.lang.TodayStrategies;
import infra.session.SessionIdGenerator;
import java.security.SecureRandom;

public class SecureRandomSessionIdGenerator
implements SessionIdGenerator {
    private final SecureRandom random = new SecureRandom();
    private int length = 15;
    private static final char[] SESSION_ID_ALPHABET;
    private static final String ALPHABET_PROPERTY = "server.session.id.source";

    @Override
    public String generateId() {
        byte[] bytes = new byte[this.length];
        this.random.nextBytes(bytes);
        return new String(this.encode(bytes));
    }

    public void setSessionIdLength(int length) {
        Assert.isTrue((length > 0 ? 1 : 0) != 0, (String)"length must be greater than 0");
        this.length = length / 4 * 3;
    }

    private char[] encode(byte[] data) {
        char[] out = new char[(data.length + 2) / 3 * 4];
        char[] alphabet = SESSION_ID_ALPHABET;
        int i = 0;
        int index = 0;
        while (i < data.length) {
            boolean quad = false;
            boolean trip = false;
            int val = 0xFF & data[i];
            val <<= 8;
            if (i + 1 < data.length) {
                val |= 0xFF & data[i + 1];
                trip = true;
            }
            val <<= 8;
            if (i + 2 < data.length) {
                val |= 0xFF & data[i + 2];
                quad = true;
            }
            out[index + 3] = alphabet[quad ? val & 0x3F : 63];
            out[index + 2] = alphabet[trip ? (val >>= 6) & 0x3F : 63];
            out[index + 1] = alphabet[(val >>= 6) & 0x3F];
            out[index] = alphabet[(val >>= 6) & 0x3F];
            i += 3;
            index += 4;
        }
        return out;
    }

    static {
        String alphabet = TodayStrategies.getProperty((String)ALPHABET_PROPERTY, (String)"ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789-_");
        Assert.state((alphabet.length() == 64 ? 1 : 0) != 0, (String)"SecureRandomSessionIdGenerator must be exactly 64 characters long");
        SESSION_ID_ALPHABET = alphabet.toCharArray();
    }
}

