/*
 * Decompiled with CFR 0.152.
 */
package infra.session;

import infra.lang.Assert;
import infra.lang.Nullable;
import infra.session.SessionIdResolver;
import infra.web.RequestContext;

public class RequestParameterSessionIdResolver
implements SessionIdResolver {
    private final String parameterName;

    public RequestParameterSessionIdResolver(String parameterName) {
        Assert.hasText((String)parameterName, (String)"parameterName is required");
        this.parameterName = parameterName;
    }

    @Override
    @Nullable
    public String getSessionId(RequestContext exchange) {
        Object attribute = exchange.getAttribute(WRITTEN_SESSION_ID_ATTR);
        if (attribute instanceof String) {
            String sessionId = (String)attribute;
            return sessionId;
        }
        return exchange.getParameter(this.parameterName);
    }

    @Override
    public void setSessionId(RequestContext exchange, String sessionId) {
        Assert.notNull((Object)sessionId, (String)"sessionId is required");
        exchange.setAttribute(WRITTEN_SESSION_ID_ATTR, sessionId);
    }

    @Override
    public void expireSession(RequestContext exchange) {
        exchange.removeAttribute(WRITTEN_SESSION_ID_ATTR);
    }
}

