/*
 * Decompiled with CFR 0.152.
 */
package infra.session;

import infra.beans.factory.DisposableBean;
import infra.lang.Assert;
import infra.lang.Nullable;
import infra.logging.Logger;
import infra.logging.LoggerFactory;
import infra.session.SessionPersister;
import infra.session.SessionRepository;
import infra.session.WebSession;
import infra.session.WebSessionEvent;
import infra.session.WebSessionListener;
import infra.util.StringUtils;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;

public class PersistenceSessionRepository
implements SessionRepository,
DisposableBean {
    private static final Logger log = LoggerFactory.getLogger(PersistenceSessionRepository.class);
    private final SessionRepository delegate;
    private final SessionPersister sessionPersister;

    public PersistenceSessionRepository(SessionPersister sessionPersister, SessionRepository delegate) {
        Assert.notNull((Object)sessionPersister, (String)"SessionPersister is required");
        Assert.notNull((Object)delegate, (String)"SessionRepository is required");
        this.sessionPersister = sessionPersister;
        this.delegate = delegate;
    }

    @Override
    public WebSession createSession() {
        return this.delegate.createSession();
    }

    @Override
    public WebSession createSession(String id) {
        return this.delegate.createSession(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public WebSession retrieveSession(String sessionId) {
        WebSession session = this.delegate.retrieveSession(sessionId);
        if (session == null) {
            String string = sessionId.intern();
            synchronized (string) {
                session = this.delegate.retrieveSession(sessionId);
                if (session == null) {
                    try {
                        session = this.sessionPersister.findById(sessionId);
                    }
                    catch (IOException | ClassNotFoundException e) {
                        log.error("Unable to get session from SessionPersister: {}", (Object)this.sessionPersister, (Throwable)e);
                    }
                }
            }
        }
        return session;
    }

    @Override
    public void removeSession(WebSession session) {
        this.removeSession(session.getId());
    }

    @Override
    @Nullable
    public WebSession removeSession(String sessionId) {
        WebSession ret = this.delegate.removeSession(sessionId);
        PersistenceSessionRepository.removePersister(sessionId, this.sessionPersister);
        return ret;
    }

    @Override
    public void updateLastAccessTime(WebSession webSession) {
        this.delegate.updateLastAccessTime(webSession);
    }

    @Override
    public boolean contains(String id) {
        return this.delegate.contains(id) || this.sessionPersister.contains(id);
    }

    @Override
    public int getSessionCount() {
        return this.getIdentifiers().length;
    }

    @Override
    public String[] getIdentifiers() {
        HashSet identifiers = new HashSet();
        Collections.addAll(identifiers, this.delegate.getIdentifiers());
        Collections.addAll(identifiers, this.sessionPersister.keys());
        return StringUtils.toStringArray(identifiers);
    }

    public void persistSessions() {
        for (String identifier : this.delegate.getIdentifiers()) {
            WebSession session = this.delegate.retrieveSession(identifier);
            if (session == null) continue;
            try {
                this.sessionPersister.persist(session);
            }
            catch (IOException e) {
                log.error("Unable to persist session: '{}' from SessionPersister: {}", (Object)session, (Object)this.sessionPersister, (Throwable)e);
            }
        }
    }

    public void destroy() {
        this.persistSessions();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void removePersister(String sessionId, SessionPersister sessionPersister) {
        try {
            String string = sessionId.intern();
            synchronized (string) {
                sessionPersister.remove(sessionId);
            }
        }
        catch (IOException e) {
            log.error("Unable to remove session from SessionPersister: {}", (Object)sessionPersister, (Throwable)e);
        }
    }

    public WebSessionListener createDestructionCallback() {
        return PersistenceSessionRepository.createDestructionCallback(this.sessionPersister);
    }

    public static WebSessionListener createDestructionCallback(SessionPersister sessionPersister) {
        Assert.notNull((Object)sessionPersister, (String)"No SessionPersister");
        return new PersisterDestructionCallback(sessionPersister);
    }

    static class PersisterDestructionCallback
    implements WebSessionListener {
        final SessionPersister sessionPersister;

        public PersisterDestructionCallback(SessionPersister sessionPersister) {
            this.sessionPersister = sessionPersister;
        }

        @Override
        public void sessionDestroyed(WebSessionEvent se) {
            String sessionId = se.getSessionId();
            PersistenceSessionRepository.removePersister(sessionId, this.sessionPersister);
        }
    }
}

