/*
 * Decompiled with CFR 0.152.
 */
package infra.session;

import infra.lang.Assert;
import infra.session.AbstractWebSession;
import infra.session.SessionEventDispatcher;
import infra.session.WebSession;
import java.io.Serializable;
import java.time.Duration;
import java.time.Instant;
import java.util.UUID;

public class MapSession
extends AbstractWebSession
implements WebSession,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final int DEFAULT_MAX_INACTIVE_INTERVAL_SECONDS = 1800;
    private String id;
    private final String originalId;
    private Instant creationTime;
    private Instant lastAccessTime;
    private Duration maxIdleTime;

    public MapSession() {
        this(UUID.randomUUID().toString());
    }

    public MapSession(String id) {
        this(id, new SessionEventDispatcher());
    }

    public MapSession(String id, SessionEventDispatcher eventDispatcher) {
        super(eventDispatcher);
        this.lastAccessTime = this.creationTime = Instant.now();
        this.maxIdleTime = Duration.ofSeconds(1800L);
        Assert.notNull((Object)id, (String)"sessionId is required");
        this.id = id;
        this.originalId = id;
    }

    public MapSession(WebSession session) {
        super(MapSession.getEventDispatcher(session));
        this.lastAccessTime = this.creationTime = Instant.now();
        this.maxIdleTime = Duration.ofSeconds(1800L);
        this.originalId = this.id = session.getId();
        this.maxIdleTime = session.getMaxIdleTime();
        this.creationTime = session.getCreationTime();
        this.lastAccessTime = session.getLastAccessTime();
        this.copyAttributesFrom(session);
    }

    static SessionEventDispatcher getEventDispatcher(WebSession session) {
        Assert.notNull((Object)session, (String)"session is required");
        if (session instanceof AbstractWebSession) {
            AbstractWebSession mapSession = (AbstractWebSession)session;
            return mapSession.eventDispatcher;
        }
        return new SessionEventDispatcher();
    }

    @Override
    public String getId() {
        return this.id;
    }

    public String getOriginalId() {
        return this.originalId;
    }

    @Override
    public void start() {
        this.eventDispatcher.onSessionCreated(this);
    }

    @Override
    public boolean isStarted() {
        return true;
    }

    @Override
    public void changeSessionId() {
        this.id = MapSession.generateId();
    }

    @Override
    public void save() {
    }

    @Override
    protected void doInvalidate() {
        if (this.attributes != null) {
            this.attributes.clear();
        }
    }

    @Override
    public boolean isExpired() {
        return this.isExpired(Instant.now());
    }

    boolean isExpired(Instant now) {
        if (this.maxIdleTime.isNegative()) {
            return false;
        }
        return now.minus(this.maxIdleTime).compareTo(this.lastAccessTime) >= 0;
    }

    @Override
    public Instant getCreationTime() {
        return this.creationTime;
    }

    @Override
    public Instant getLastAccessTime() {
        return this.lastAccessTime;
    }

    @Override
    public void setLastAccessTime(Instant lastAccessTime) {
        this.lastAccessTime = lastAccessTime;
    }

    @Override
    public void setMaxIdleTime(Duration maxIdleTime) {
        this.maxIdleTime = maxIdleTime;
    }

    @Override
    public Duration getMaxIdleTime() {
        return this.maxIdleTime;
    }

    public void setCreationTime(Instant creationTime) {
        this.creationTime = creationTime;
    }

    public void setId(String id) {
        this.id = id;
    }

    public boolean equals(Object obj) {
        WebSession session;
        return obj == this || obj instanceof WebSession && this.id.equals((session = (WebSession)obj).getId());
    }

    @Override
    public int hashCode() {
        return this.id.hashCode();
    }

    private static String generateId() {
        return UUID.randomUUID().toString();
    }
}

