/*
 * Decompiled with CFR 0.152.
 */
package infra.session;

import infra.lang.Assert;
import infra.lang.Nullable;
import infra.session.SessionIdResolver;
import infra.web.RequestContext;

public class HeaderSessionIdResolver
implements SessionIdResolver {
    private final String headerName;

    public HeaderSessionIdResolver(String headerName) {
        Assert.hasText((String)headerName, (String)"headerName is required");
        this.headerName = headerName;
    }

    @Override
    @Nullable
    public String getSessionId(RequestContext exchange) {
        Object attribute = exchange.getAttribute(WRITTEN_SESSION_ID_ATTR);
        if (attribute instanceof String) {
            String sessionId = (String)attribute;
            return sessionId;
        }
        return exchange.requestHeaders().getFirst(this.headerName);
    }

    @Override
    public void setSessionId(RequestContext exchange, String sessionId) {
        Assert.notNull((Object)sessionId, (String)"sessionId is required");
        exchange.setHeader(this.headerName, sessionId);
        exchange.setAttribute(WRITTEN_SESSION_ID_ATTR, sessionId);
    }

    @Override
    public void expireSession(RequestContext exchange) {
        exchange.removeHeader(this.headerName);
        exchange.removeAttribute(WRITTEN_SESSION_ID_ATTR);
    }
}

