/*
 * Decompiled with CFR 0.152.
 */
package infra.session;

import infra.core.ApplicationTemp;
import infra.lang.Assert;
import infra.lang.Constant;
import infra.lang.Nullable;
import infra.logging.Logger;
import infra.logging.LoggerFactory;
import infra.session.MapSession;
import infra.session.SerializableSession;
import infra.session.SessionPersister;
import infra.session.SessionRepository;
import infra.session.WebSession;
import infra.session.config.SessionProperties;
import infra.util.ObjectUtils;
import infra.util.StringUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;

public class FileSessionPersister
implements SessionPersister {
    private static final Logger log = LoggerFactory.getLogger(FileSessionPersister.class);
    private static final String FILE_EXT = ".session";
    @Nullable
    private File directory;
    @Nullable
    private ApplicationTemp applicationTemp;
    private final SessionRepository repository;

    public FileSessionPersister(SessionRepository repository) {
        Assert.notNull((Object)repository, (String)"SessionRepository is required");
        this.repository = repository;
    }

    public void setDirectory(@Nullable File directory) {
        this.directory = directory;
    }

    public void setApplicationTemp(@Nullable ApplicationTemp applicationTemp) {
        this.applicationTemp = applicationTemp;
    }

    @Override
    public void remove(String id) throws IOException {
        File file = this.sessionFile(id);
        if (log.isDebugEnabled()) {
            log.debug("Removing Session [{}] at file [{}]", (Object)id, (Object)file.getAbsolutePath());
        }
        if (file.exists() && !file.delete()) {
            throw new IOException("Unable to delete file [%s] which is no longer required".formatted(file));
        }
    }

    @Override
    public boolean contains(String id) {
        File file = this.sessionFile(id);
        return file.exists();
    }

    @Override
    public void clear() throws IOException {
        String[] keys;
        for (String key : keys = this.keys()) {
            this.remove(key);
        }
    }

    @Override
    public String[] keys() {
        Object[] files = this.directory().list();
        if (ObjectUtils.isEmpty((Object[])files)) {
            return Constant.EMPTY_STRING_ARRAY;
        }
        ArrayList<String> list = new ArrayList<String>();
        int n = FILE_EXT.length();
        for (Object file : files) {
            if (!((String)file).endsWith(FILE_EXT)) continue;
            list.add(((String)file).substring(0, ((String)file).length() - n));
        }
        return StringUtils.toStringArray(list);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @Nullable
    public WebSession findById(String id) throws ClassNotFoundException, IOException {
        File file = this.sessionFile(id);
        if (!file.exists()) {
            return null;
        }
        if (log.isDebugEnabled()) {
            log.debug("Loading Session [{}] from file [{}]", (Object)id, (Object)file.getAbsolutePath());
        }
        try (ObjectInputStream ois = new ObjectInputStream(new FileInputStream(file));){
            WebSession session = this.repository.createSession(id);
            if (session instanceof SerializableSession) {
                SerializableSession serialized = (SerializableSession)((Object)session);
                serialized.readObjectData(ois);
            } else {
                Object object = ois.readObject();
                if (object instanceof WebSession) {
                    WebSession ret = (WebSession)object;
                    object = new MapSession(ret);
                    return object;
                }
            }
            WebSession webSession = session;
            return webSession;
        }
        catch (FileNotFoundException e) {
            log.debug("No persisted data file found");
            return null;
        }
    }

    @Override
    public void persist(WebSession session) throws IOException {
        File file = this.sessionFile(session.getId());
        if (log.isDebugEnabled()) {
            log.debug("Saving Session [{}] to file [{}]", (Object)session.getId(), (Object)file.getAbsolutePath());
        }
        try (ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(file));){
            if (session instanceof SerializableSession) {
                SerializableSession serialized = (SerializableSession)((Object)session);
                serialized.writeObjectData(oos);
            } else {
                oos.writeObject(session);
            }
        }
    }

    private File directory() {
        File directory = this.directory;
        if (directory == null) {
            this.directory = directory = SessionProperties.getValidStoreDir(this.applicationTemp, null, true);
        }
        return directory;
    }

    private File sessionFile(String id) {
        String filename = id + FILE_EXT;
        return new File(this.directory(), filename);
    }
}

