/*
 * Decompiled with CFR 0.152.
 */
package infra.session;

import infra.lang.Assert;
import infra.lang.Nullable;
import infra.session.CookieSessionIdResolver;
import infra.session.SessionIdResolver;
import infra.session.SessionManager;
import infra.session.SessionRepository;
import infra.session.WebSession;
import infra.util.StringUtils;
import infra.web.RequestContext;

public class DefaultSessionManager
implements SessionManager {
    private SessionIdResolver sessionIdResolver;
    private SessionRepository sessionRepository;

    public DefaultSessionManager(SessionRepository sessionRepository, @Nullable SessionIdResolver sessionIdResolver) {
        if (sessionIdResolver == null) {
            sessionIdResolver = new CookieSessionIdResolver();
        }
        this.setSessionRepository(sessionRepository);
        this.setSessionIdResolver(sessionIdResolver);
    }

    public void setSessionRepository(SessionRepository sessionRepository) {
        Assert.notNull((Object)sessionRepository, (String)"sessionRepository is required");
        this.sessionRepository = sessionRepository;
    }

    public void setSessionIdResolver(SessionIdResolver sessionIdResolver) {
        Assert.notNull((Object)sessionIdResolver, (String)"sessionIdResolver is required");
        this.sessionIdResolver = sessionIdResolver;
    }

    @Override
    public WebSession createSession() {
        return this.sessionRepository.createSession();
    }

    @Override
    public WebSession createSession(RequestContext context) {
        WebSession session = this.sessionRepository.createSession();
        session.start();
        session.save();
        this.sessionIdResolver.setSessionId(context, session.getId());
        return session;
    }

    @Override
    @Nullable
    public WebSession getSession(@Nullable String sessionId) {
        if (StringUtils.hasText((String)sessionId)) {
            return this.sessionRepository.retrieveSession(sessionId);
        }
        return null;
    }

    @Override
    public WebSession getSession(RequestContext context) {
        return this.getSession(context, true);
    }

    @Override
    @Nullable
    public WebSession getSession(RequestContext context, boolean create) {
        String sessionId = this.sessionIdResolver.getSessionId(context);
        if (StringUtils.hasText((String)sessionId)) {
            WebSession session = this.sessionRepository.retrieveSession(sessionId);
            if (session == null && create) {
                session = this.createSession(context);
            }
            return session;
        }
        if (create) {
            return this.createSession(context);
        }
        return null;
    }
}

