/*
 * Decompiled with CFR 0.152.
 */
package infra.session;

import infra.http.HttpCookie;
import infra.lang.Assert;
import infra.lang.Nullable;
import infra.session.SessionIdResolver;
import infra.session.config.CookieProperties;
import infra.web.RequestContext;

public class CookieSessionIdResolver
implements SessionIdResolver {
    private final String cookieName;
    private final CookieProperties config;

    public CookieSessionIdResolver() {
        this(new CookieProperties());
    }

    public CookieSessionIdResolver(String cookieName) {
        Assert.notNull((Object)cookieName, (String)"Cookie name is required");
        this.config = new CookieProperties();
        this.cookieName = cookieName;
        this.config.setName(cookieName);
    }

    public CookieSessionIdResolver(CookieProperties config) {
        Assert.notNull((Object)config, (String)"Cookie config is required");
        Assert.notNull((Object)config.getName(), (String)"Cookie name is required");
        this.config = config;
        this.cookieName = config.getName();
    }

    @Override
    @Nullable
    public String getSessionId(RequestContext exchange) {
        Object attribute = exchange.getAttribute(WRITTEN_SESSION_ID_ATTR);
        if (attribute instanceof String) {
            String sessionId = (String)attribute;
            return sessionId;
        }
        HttpCookie cookie = exchange.getCookie(this.cookieName);
        if (cookie == null) {
            if (exchange.hasResponseCookie()) {
                for (HttpCookie httpCookie : exchange.responseCookies()) {
                    if (!this.cookieName.equals(httpCookie.getName())) continue;
                    return httpCookie.getValue();
                }
            }
            return null;
        }
        return cookie.getValue();
    }

    @Override
    public void setSessionId(RequestContext exchange, String sessionId) {
        if (!sessionId.equals(exchange.getAttribute(WRITTEN_SESSION_ID_ATTR))) {
            HttpCookie cookie = this.createCookie(sessionId);
            exchange.addCookie(cookie);
            exchange.setAttribute(WRITTEN_SESSION_ID_ATTR, sessionId);
        }
    }

    @Override
    public void expireSession(RequestContext exchange) {
        exchange.removeCookie(this.cookieName);
        exchange.removeAttribute(WRITTEN_SESSION_ID_ATTR);
    }

    public String getCookieName() {
        return this.cookieName;
    }

    public HttpCookie createCookie(String id) {
        return this.config.createCookie(id);
    }
}

