/*
 * Decompiled with CFR 0.152.
 */
package infra.session;

import infra.core.AttributeAccessor;
import infra.lang.Assert;
import infra.lang.Constant;
import infra.lang.Nullable;
import infra.session.AttributeBindingListener;
import infra.session.SessionEventDispatcher;
import infra.session.WebSession;
import infra.util.CollectionUtils;
import infra.util.ObjectUtils;
import infra.util.StringUtils;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public abstract class AbstractWebSession
implements WebSession {
    @Nullable
    protected Map<String, Object> attributes;
    protected final transient SessionEventDispatcher eventDispatcher;

    protected AbstractWebSession(SessionEventDispatcher eventDispatcher) {
        this.eventDispatcher = eventDispatcher;
    }

    public void setAttributes(@Nullable Map<String, Object> attributes) {
        if (CollectionUtils.isNotEmpty(attributes)) {
            for (Map.Entry<String, Object> entry : attributes.entrySet()) {
                this.setAttribute(entry.getKey(), entry.getValue());
            }
        }
    }

    @Override
    public void setAttribute(String name, @Nullable Object value) {
        if (value != null) {
            Object oldValue = this.getAttributes().put(name, value);
            if (this.attributeBinding(value, oldValue)) {
                AttributeBindingListener listener;
                if (oldValue instanceof AttributeBindingListener) {
                    listener = (AttributeBindingListener)oldValue;
                    listener.valueUnbound(this, name);
                }
                if (value instanceof AttributeBindingListener) {
                    listener = (AttributeBindingListener)value;
                    listener.valueBound(this, name);
                }
            }
            if (oldValue != null) {
                if (this.allowAttributeReplaced(value, oldValue)) {
                    this.attributeReplaced(name, oldValue, value);
                }
            } else {
                this.attributeAdded(name, value);
            }
        } else {
            this.removeAttribute(name);
        }
    }

    protected boolean attributeBinding(Object value, @Nullable Object oldValue) {
        return oldValue != value;
    }

    protected boolean allowAttributeReplaced(Object value, @Nullable Object oldValue) {
        return oldValue != value;
    }

    protected void attributeAdded(String name, Object value) {
        this.eventDispatcher.attributeAdded(this, name, value);
    }

    protected void attributeReplaced(String name, Object oldValue, Object value) {
        this.eventDispatcher.attributeReplaced(this, name, oldValue, value);
    }

    protected void attributeRemoved(String name, Object attribute) {
        this.eventDispatcher.attributeRemoved(this, name, attribute);
    }

    @Override
    @Nullable
    public Object getAttribute(String name) {
        Map<String, Object> attributes = this.attributes;
        if (attributes == null) {
            return null;
        }
        return attributes.get(name);
    }

    @Override
    public Object removeAttribute(String name) {
        Map<String, Object> attributes = this.attributes;
        if (attributes != null) {
            Object attribute = attributes.remove(name);
            if (attribute instanceof AttributeBindingListener) {
                AttributeBindingListener listener = (AttributeBindingListener)attribute;
                listener.valueUnbound(this, name);
            }
            if (attribute != null) {
                this.attributeRemoved(name, attribute);
            }
            return attribute;
        }
        return null;
    }

    @Override
    public void invalidate() {
        this.eventDispatcher.onSessionDestroyed(this);
        for (String attributeName : this.getAttributeNames()) {
            this.removeAttribute(attributeName);
        }
        this.doInvalidate();
    }

    protected void doInvalidate() {
    }

    @Override
    public boolean hasAttribute(String name) {
        Map<String, Object> attributes = this.attributes;
        if (attributes != null) {
            return attributes.containsKey(name);
        }
        return false;
    }

    @Override
    public String[] getAttributeNames() {
        Map<String, Object> attributes = this.attributes;
        if (attributes != null) {
            return StringUtils.toStringArray(attributes.keySet());
        }
        return Constant.EMPTY_STRING_ARRAY;
    }

    @Override
    public Iterable<String> attributeNames() {
        Map<String, Object> attributes = this.attributes;
        if (attributes != null) {
            return attributes.keySet();
        }
        return Collections.emptyList();
    }

    protected final void copyAttributesFrom(WebSession source) {
        Assert.notNull((Object)source, (String)"Source is required");
        for (String attributeName : source.getAttributeNames()) {
            this.setAttribute(attributeName, source.getAttribute(attributeName));
        }
    }

    @Override
    public boolean hasAttributes() {
        Map<String, Object> attributes = this.attributes;
        return attributes != null && !attributes.isEmpty();
    }

    public int hashCode() {
        return ObjectUtils.nullSafeHashCode(this.attributes);
    }

    @Override
    public Map<String, Object> getAttributes() {
        Map<String, Object> attributes = this.attributes;
        if (attributes == null) {
            this.attributes = attributes = this.createAttributes();
        }
        return attributes;
    }

    protected Map<String, Object> createAttributes() {
        return new HashMap<String, Object>();
    }

    public void copyFrom(AttributeAccessor source) {
        Assert.notNull((Object)source, (String)"Source is required");
        for (String attributeName : source.getAttributeNames()) {
            this.setAttribute(attributeName, source.getAttribute(attributeName));
        }
    }

    public void clearAttributes() {
        if (this.attributes != null) {
            this.attributes.clear();
        }
    }
}

