/*
 * Decompiled with CFR 0.152.
 */
package infra.http.support;

import infra.http.HttpHeaders;
import infra.lang.Nullable;
import infra.util.CollectionUtils;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public final class Netty4HttpHeaders
extends HttpHeaders {
    private final io.netty.handler.codec.http.HttpHeaders headers;

    public Netty4HttpHeaders(io.netty.handler.codec.http.HttpHeaders headers) {
        this.headers = headers;
    }

    @Override
    @Nullable
    public String getFirst(String name) {
        return this.headers.get(name);
    }

    @Override
    public void add(String name, @Nullable String value) {
        if (value != null) {
            this.headers.add(name, (Object)value);
        }
    }

    public void addAll(String key, @Nullable Collection<? extends String> values) {
        if (values != null) {
            this.headers.add(key, values);
        }
    }

    @Override
    public void setHeader(String name, String value) {
        this.headers.set(name, (Object)value);
    }

    public Map<String, String> toSingleValueMap() {
        LinkedHashMap singleValueMap = CollectionUtils.newLinkedHashMap((int)this.headers.size());
        for (Map.Entry entry : this.headers) {
            singleValueMap.put((String)entry.getKey(), (String)entry.getValue());
        }
        return singleValueMap;
    }

    public int size() {
        return this.headers.names().size();
    }

    public boolean isEmpty() {
        return this.headers.isEmpty();
    }

    public boolean containsKey(Object key) {
        String headerName;
        return key instanceof String && this.headers.contains(headerName = (String)key);
    }

    public boolean containsValue(Object value) {
        if (value instanceof String) {
            for (Map.Entry header : this.headers) {
                if (!Objects.equals(header.getValue(), value)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    @Nullable
    public List<String> get(Object name) {
        if (this.containsKey(name)) {
            return this.headers.getAll((String)name);
        }
        return null;
    }

    @Nullable
    public List<String> put(String key, @Nullable List<String> value) {
        List previousValues = this.headers.getAll(key);
        this.headers.set(key, value);
        return previousValues;
    }

    @Override
    @Nullable
    public List<String> remove(Object name) {
        if (name instanceof String) {
            String headerName = (String)name;
            List previousValues = this.headers.getAll(headerName);
            this.headers.remove(headerName);
            return previousValues;
        }
        return null;
    }

    public void putAll(Map<? extends String, ? extends List<String>> m) {
        for (Map.Entry<? extends String, ? extends List<String>> entry : m.entrySet()) {
            this.headers.set(entry.getKey(), (Iterable)entry.getValue());
        }
    }

    public void clear() {
        this.headers.clear();
    }

    public Set<String> keySet() {
        return new HeaderNames();
    }

    public Collection<List<String>> values() {
        io.netty.handler.codec.http.HttpHeaders headers = this.headers;
        ArrayList<List<String>> ret = new ArrayList<List<String>>(headers.size());
        for (String name : headers.names()) {
            ret.add(headers.getAll(name));
        }
        return ret;
    }

    public Set<Map.Entry<String, List<String>>> entrySet() {
        return new AbstractSet<Map.Entry<String, List<String>>>(){

            @Override
            public Iterator<Map.Entry<String, List<String>>> iterator() {
                return new EntryIterator();
            }

            @Override
            public int size() {
                return Netty4HttpHeaders.this.headers.size();
            }
        };
    }

    private class HeaderNames
    extends AbstractSet<String> {
        private HeaderNames() {
        }

        @Override
        public Iterator<String> iterator() {
            return new HeaderNamesIterator(Netty4HttpHeaders.this.headers.names().iterator());
        }

        @Override
        public int size() {
            return Netty4HttpHeaders.this.headers.names().size();
        }
    }

    private final class HeaderNamesIterator
    implements Iterator<String> {
        private final Iterator<String> iterator;
        @Nullable
        private String currentName;

        private HeaderNamesIterator(Iterator<String> iterator) {
            this.iterator = iterator;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public String next() {
            this.currentName = this.iterator.next();
            return this.currentName;
        }

        @Override
        public void remove() {
            if (this.currentName == null) {
                throw new IllegalStateException("No current Header in iterator");
            }
            if (!Netty4HttpHeaders.this.headers.contains(this.currentName)) {
                throw new IllegalStateException("Header not present: " + this.currentName);
            }
            Netty4HttpHeaders.this.headers.remove(this.currentName);
        }
    }

    private class HeaderEntry
    implements Map.Entry<String, List<String>> {
        private final String key;

        HeaderEntry(String key) {
            this.key = key;
        }

        @Override
        public String getKey() {
            return this.key;
        }

        @Override
        public List<String> getValue() {
            return Netty4HttpHeaders.this.headers.getAll(this.key);
        }

        @Override
        public List<String> setValue(List<String> value) {
            List previousValues = Netty4HttpHeaders.this.headers.getAll(this.key);
            Netty4HttpHeaders.this.headers.set(this.key, value);
            return previousValues;
        }
    }

    private class EntryIterator
    implements Iterator<Map.Entry<String, List<String>>> {
        private final Iterator<String> names;

        private EntryIterator() {
            this.names = Netty4HttpHeaders.this.headers.names().iterator();
        }

        @Override
        public boolean hasNext() {
            return this.names.hasNext();
        }

        @Override
        public Map.Entry<String, List<String>> next() {
            return new HeaderEntry(this.names.next());
        }
    }
}

