/*
 * Decompiled with CFR 0.152.
 */
package infra.http.server.reactive;

import infra.http.HttpStatus;
import infra.http.HttpStatusCode;
import infra.http.ReactiveHttpOutputMessage;
import infra.http.ResponseCookie;
import infra.lang.Nullable;
import infra.util.MultiValueMap;

public interface ServerHttpResponse
extends ReactiveHttpOutputMessage {
    public boolean setStatusCode(@Nullable HttpStatus var1);

    @Nullable
    public HttpStatusCode getStatusCode();

    default public boolean setRawStatusCode(@Nullable Integer value) {
        if (value == null) {
            return this.setStatusCode(null);
        }
        HttpStatus httpStatus = HttpStatus.resolve(value);
        if (httpStatus == null) {
            throw new IllegalStateException("Unresolvable HttpStatus for general ServerHttpResponse: " + value);
        }
        return this.setStatusCode(httpStatus);
    }

    @Nullable
    default public Integer getRawStatusCode() {
        HttpStatusCode httpStatus = this.getStatusCode();
        return httpStatus != null ? Integer.valueOf(httpStatus.value()) : null;
    }

    public MultiValueMap<String, ResponseCookie> getCookies();

    public void addCookie(ResponseCookie var1);
}

