/*
 * Decompiled with CFR 0.152.
 */
package infra.http.server.reactive;

import infra.core.AttributeAccessor;
import infra.core.io.buffer.DataBuffer;
import infra.http.HttpCookie;
import infra.http.HttpHeaders;
import infra.http.HttpMethod;
import infra.http.server.RequestPath;
import infra.http.server.reactive.AbstractServerHttpRequest;
import infra.http.server.reactive.ServerHttpRequest;
import infra.http.server.reactive.SslInfo;
import infra.lang.Assert;
import infra.lang.Nullable;
import infra.util.MultiValueMap;
import java.net.InetSocketAddress;
import java.net.URI;
import java.util.Map;
import java.util.function.Function;
import reactor.core.publisher.Flux;

public class ServerHttpRequestDecorator
implements ServerHttpRequest {
    private final ServerHttpRequest delegate;

    public ServerHttpRequestDecorator(ServerHttpRequest delegate) {
        Assert.notNull((Object)delegate, (String)"Delegate is required");
        this.delegate = delegate;
    }

    public ServerHttpRequest getDelegate() {
        return this.delegate;
    }

    @Override
    public String getId() {
        return this.getDelegate().getId();
    }

    @Override
    public HttpMethod getMethod() {
        return this.getDelegate().getMethod();
    }

    @Override
    public String getMethodValue() {
        return this.getDelegate().getMethodValue();
    }

    @Override
    public URI getURI() {
        return this.getDelegate().getURI();
    }

    @Override
    public RequestPath getPath() {
        return this.getDelegate().getPath();
    }

    @Override
    public MultiValueMap<String, String> getQueryParams() {
        return this.getDelegate().getQueryParams();
    }

    @Override
    public HttpHeaders getHeaders() {
        return this.getDelegate().getHeaders();
    }

    @Override
    public MultiValueMap<String, HttpCookie> getCookies() {
        return this.getDelegate().getCookies();
    }

    @Override
    @Nullable
    public InetSocketAddress getLocalAddress() {
        return this.getDelegate().getLocalAddress();
    }

    @Override
    @Nullable
    public InetSocketAddress getRemoteAddress() {
        return this.getDelegate().getRemoteAddress();
    }

    @Override
    @Nullable
    public SslInfo getSslInfo() {
        return this.getDelegate().getSslInfo();
    }

    @Override
    public Flux<DataBuffer> getBody() {
        return this.getDelegate().getBody();
    }

    @Override
    public Map<String, Object> getAttributes() {
        return this.getDelegate().getAttributes();
    }

    public void setAttributes(@Nullable Map<String, Object> attributes) {
        this.getDelegate().setAttributes(attributes);
    }

    public Iterable<String> attributeNames() {
        return this.getDelegate().attributeNames();
    }

    public void clearAttributes() {
        this.getDelegate().clearAttributes();
    }

    public <T> T computeAttribute(String name, Function<String, T> computeFunction) {
        return (T)this.getDelegate().computeAttribute(name, computeFunction);
    }

    public void copyFrom(AttributeAccessor source) {
        this.getDelegate().copyFrom(source);
    }

    @Nullable
    public Object getAttribute(String name) {
        return this.getDelegate().getAttribute(name);
    }

    public String[] getAttributeNames() {
        return this.getDelegate().getAttributeNames();
    }

    public boolean hasAttribute(String name) {
        return this.getDelegate().hasAttribute(name);
    }

    public boolean hasAttributes() {
        return this.getDelegate().hasAttributes();
    }

    @Nullable
    public Object removeAttribute(String name) {
        return this.getDelegate().removeAttribute(name);
    }

    public void setAttribute(String name, @Nullable Object value) {
        this.getDelegate().setAttribute(name, value);
    }

    public static <T> T getNativeRequest(ServerHttpRequest request) {
        if (request instanceof AbstractServerHttpRequest) {
            return ((AbstractServerHttpRequest)request).getNativeRequest();
        }
        if (request instanceof ServerHttpRequestDecorator) {
            return ServerHttpRequestDecorator.getNativeRequest(((ServerHttpRequestDecorator)request).getDelegate());
        }
        throw new IllegalArgumentException("Can't find native request in " + request.getClass().getName());
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [delegate=" + this.getDelegate() + "]";
    }
}

