/*
 * Decompiled with CFR 0.152.
 */
package infra.http.server.reactive;

import infra.http.HttpCookie;
import infra.http.HttpHeaders;
import infra.http.HttpMethod;
import infra.http.HttpRequest;
import infra.http.ReactiveHttpInputMessage;
import infra.http.server.RequestPath;
import infra.http.server.reactive.DefaultServerHttpRequestBuilder;
import infra.http.server.reactive.SslInfo;
import infra.lang.Nullable;
import infra.util.MultiValueMap;
import java.net.InetSocketAddress;
import java.net.URI;
import java.util.function.Consumer;

public interface ServerHttpRequest
extends HttpRequest,
ReactiveHttpInputMessage {
    public String getId();

    public RequestPath getPath();

    public MultiValueMap<String, String> getQueryParams();

    public MultiValueMap<String, HttpCookie> getCookies();

    @Nullable
    default public InetSocketAddress getLocalAddress() {
        return null;
    }

    @Nullable
    default public InetSocketAddress getRemoteAddress() {
        return null;
    }

    @Nullable
    default public SslInfo getSslInfo() {
        return null;
    }

    default public Builder mutate() {
        return new DefaultServerHttpRequestBuilder(this);
    }

    public static interface Builder {
        public Builder method(HttpMethod var1);

        public Builder uri(URI var1);

        public Builder path(String var1);

        public Builder contextPath(String var1);

        public Builder header(String var1, String ... var2);

        public Builder headers(Consumer<HttpHeaders> var1);

        public Builder sslInfo(SslInfo var1);

        public Builder remoteAddress(InetSocketAddress var1);

        public ServerHttpRequest build();
    }
}

