/*
 * Decompiled with CFR 0.152.
 */
package infra.http.server.reactive;

import infra.lang.Assert;
import java.net.URI;
import java.net.URISyntaxException;
import reactor.netty.http.server.HttpServerRequest;

abstract class ReactorUriHelper {
    ReactorUriHelper() {
    }

    public static URI createUri(HttpServerRequest request) throws URISyntaxException {
        Assert.notNull((Object)request, (String)"HttpServerRequest is required");
        StringBuilder builder = new StringBuilder();
        String scheme = request.scheme();
        builder.append(scheme);
        builder.append("://");
        ReactorUriHelper.appendHostName(request, builder);
        int port = request.hostPort();
        if ((scheme.equals("http") || scheme.equals("ws")) && port != 80 || (scheme.equals("https") || scheme.equals("wss")) && port != 443) {
            builder.append(':');
            builder.append(port);
        }
        ReactorUriHelper.appendRequestUri(request, builder);
        return new URI(builder.toString());
    }

    private static void appendHostName(HttpServerRequest request, StringBuilder builder) {
        boolean brackets;
        String hostName = request.hostName();
        boolean ipv6 = hostName.indexOf(58) != -1;
        boolean bl = brackets = ipv6 && !hostName.startsWith("[") && !hostName.endsWith("]");
        if (brackets) {
            builder.append('[');
        }
        if (ReactorUriHelper.encoded(hostName, ipv6)) {
            builder.append(hostName);
        } else {
            for (int i = 0; i < hostName.length(); ++i) {
                char c = hostName.charAt(i);
                if (ReactorUriHelper.isAllowedInHost(c, ipv6)) {
                    builder.append(c);
                    continue;
                }
                builder.append('%');
                char hex1 = Character.toUpperCase(Character.forDigit(c >> 4 & 0xF, 16));
                char hex2 = Character.toUpperCase(Character.forDigit(c & 0xF, 16));
                builder.append(hex1);
                builder.append(hex2);
            }
        }
        if (brackets) {
            builder.append(']');
        }
    }

    private static boolean encoded(String hostName, boolean ipv6) {
        int length = hostName.length();
        for (int i = 0; i < length; ++i) {
            char c = hostName.charAt(i);
            if (c == '%') {
                if (i + 2 < length) {
                    char hex1 = hostName.charAt(i + 1);
                    char hex2 = hostName.charAt(i + 2);
                    int u = Character.digit(hex1, 16);
                    int l = Character.digit(hex2, 16);
                    if (u == -1 || l == -1) {
                        return false;
                    }
                    i += 2;
                    continue;
                }
                return false;
            }
            if (ReactorUriHelper.isAllowedInHost(c, ipv6)) continue;
            return false;
        }
        return true;
    }

    private static boolean isAllowedInHost(char c, boolean ipv6) {
        return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || '-' == c || '.' == c || '_' == c || '~' == c || '!' == c || '$' == c || '&' == c || '\'' == c || '(' == c || ')' == c || '*' == c || '+' == c || ',' == c || ';' == c || '=' == c || ipv6 && ('[' == c || ']' == c || ':' == c);
    }

    private static void appendRequestUri(HttpServerRequest request, StringBuilder builder) {
        char c;
        String uri = request.uri();
        int length = uri.length();
        for (int i = 0; i < length && (c = uri.charAt(i)) != '/' && c != '?' && c != '#'; ++i) {
            if (c != ':' || i + 2 >= length || uri.charAt(i + 1) != '/' || uri.charAt(i + 2) != '/') continue;
            for (int j = i + 3; j < length; ++j) {
                c = uri.charAt(j);
                if (c != '/' && c != '?' && c != '#') continue;
                builder.append(uri, j, length);
                return;
            }
            return;
        }
        builder.append(uri);
    }
}

