/*
 * Decompiled with CFR 0.152.
 */
package infra.http.server.reactive;

import infra.core.io.buffer.DataBuffer;
import infra.core.io.buffer.DataBufferFactory;
import infra.core.io.buffer.DataBufferUtils;
import infra.core.io.buffer.Netty5DataBufferFactory;
import infra.http.HttpStatusCode;
import infra.http.ResponseCookie;
import infra.http.ZeroCopyHttpOutputMessage;
import infra.http.server.reactive.AbstractServerHttpResponse;
import infra.http.support.Netty5HttpHeaders;
import infra.lang.Assert;
import infra.logging.Logger;
import infra.logging.LoggerFactory;
import io.netty5.buffer.Buffer;
import io.netty5.channel.ChannelId;
import io.netty5.handler.codec.http.headers.DefaultHttpSetCookie;
import io.netty5.handler.codec.http.headers.HttpSetCookie;
import java.nio.file.Path;
import java.util.List;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.netty5.ChannelOperationsId;
import reactor.netty5.http.server.HttpServerResponse;

class ReactorNetty2ServerHttpResponse
extends AbstractServerHttpResponse
implements ZeroCopyHttpOutputMessage {
    private static final Logger logger = LoggerFactory.getLogger(ReactorNetty2ServerHttpResponse.class);
    private final HttpServerResponse response;

    public ReactorNetty2ServerHttpResponse(HttpServerResponse response, DataBufferFactory bufferFactory) {
        super(bufferFactory, new Netty5HttpHeaders(response.responseHeaders()));
        Assert.notNull((Object)response, (String)"HttpServerResponse is required");
        this.response = response;
    }

    @Override
    public <T> T getNativeResponse() {
        return (T)this.response;
    }

    @Override
    public HttpStatusCode getStatusCode() {
        HttpStatusCode status = super.getStatusCode();
        return status != null ? status : HttpStatusCode.valueOf(this.response.status().code());
    }

    @Override
    public Integer getRawStatusCode() {
        Integer status = super.getRawStatusCode();
        return status != null ? status.intValue() : this.response.status().code();
    }

    @Override
    protected void applyStatusCode() {
        HttpStatusCode status = super.getStatusCode();
        if (status != null) {
            this.response.status(status.value());
        }
    }

    @Override
    protected Mono<Void> writeWithInternal(Publisher<? extends DataBuffer> publisher) {
        return this.response.send(this.toByteBufs(publisher)).then();
    }

    @Override
    protected Mono<Void> writeAndFlushWithInternal(Publisher<? extends Publisher<? extends DataBuffer>> publisher) {
        return this.response.sendGroups((Publisher)Flux.from(publisher).map(this::toByteBufs)).then();
    }

    @Override
    protected void applyHeaders() {
    }

    @Override
    protected void applyCookies() {
        for (String name : this.getCookies().keySet()) {
            for (ResponseCookie httpCookie : (List)this.getCookies().get((Object)name)) {
                Long maxAge = !httpCookie.getMaxAge().isNegative() ? Long.valueOf(httpCookie.getMaxAge().getSeconds()) : null;
                HttpSetCookie.SameSite sameSite = httpCookie.getSameSite() != null ? HttpSetCookie.SameSite.valueOf((String)httpCookie.getSameSite()) : null;
                DefaultHttpSetCookie cookie = new DefaultHttpSetCookie((CharSequence)name, (CharSequence)httpCookie.getValue(), (CharSequence)httpCookie.getPath(), (CharSequence)httpCookie.getDomain(), null, maxAge, sameSite, false, httpCookie.isSecure(), httpCookie.isHttpOnly());
                this.response.addCookie((HttpSetCookie)cookie);
            }
        }
    }

    @Override
    public Mono<Void> writeWith(Path file, long position, long count) {
        return this.doCommit(() -> this.response.sendFile(file, position, count).then());
    }

    private Publisher<Buffer> toByteBufs(Publisher<? extends DataBuffer> dataBuffers) {
        return dataBuffers instanceof Mono ? Mono.from(dataBuffers).map(Netty5DataBufferFactory::toBuffer) : Flux.from(dataBuffers).map(Netty5DataBufferFactory::toBuffer);
    }

    @Override
    protected void touchDataBuffer(DataBuffer buffer) {
        if (logger.isDebugEnabled()) {
            HttpServerResponse httpServerResponse = this.response;
            if (httpServerResponse instanceof ChannelOperationsId) {
                ChannelOperationsId operationsId = (ChannelOperationsId)httpServerResponse;
                DataBufferUtils.touch((DataBuffer)buffer, (Object)("Channel id: " + operationsId.asLongText()));
            } else {
                this.response.withConnection(connection -> {
                    ChannelId id = connection.channel().id();
                    DataBufferUtils.touch((DataBuffer)buffer, (Object)("Channel id: " + id.asShortText()));
                });
            }
        }
    }
}

