/*
 * Decompiled with CFR 0.152.
 */
package infra.http.server.reactive;

import infra.core.io.buffer.DataBufferFactory;
import infra.core.io.buffer.Netty5DataBufferFactory;
import infra.http.HttpLogging;
import infra.http.HttpMethod;
import infra.http.server.reactive.HttpHandler;
import infra.http.server.reactive.HttpHeadResponseDecorator;
import infra.http.server.reactive.ReactorNetty2ServerHttpRequest;
import infra.http.server.reactive.ReactorNetty2ServerHttpResponse;
import infra.http.server.reactive.ServerHttpResponse;
import infra.lang.Assert;
import infra.logging.Logger;
import io.netty5.handler.codec.http.HttpResponseStatus;
import java.net.URISyntaxException;
import java.util.function.BiFunction;
import reactor.core.publisher.Mono;
import reactor.netty5.http.server.HttpServerRequest;
import reactor.netty5.http.server.HttpServerResponse;

public class ReactorNetty2HttpHandlerAdapter
implements BiFunction<HttpServerRequest, HttpServerResponse, Mono<Void>> {
    private static final Logger logger = HttpLogging.forLogName(ReactorNetty2HttpHandlerAdapter.class);
    private final HttpHandler httpHandler;

    public ReactorNetty2HttpHandlerAdapter(HttpHandler httpHandler) {
        Assert.notNull((Object)httpHandler, (String)"HttpHandler is required");
        this.httpHandler = httpHandler;
    }

    @Override
    public Mono<Void> apply(HttpServerRequest reactorRequest, HttpServerResponse reactorResponse) {
        Netty5DataBufferFactory bufferFactory = new Netty5DataBufferFactory(reactorResponse.alloc());
        try {
            ReactorNetty2ServerHttpRequest request = new ReactorNetty2ServerHttpRequest(reactorRequest, bufferFactory);
            ServerHttpResponse response = new ReactorNetty2ServerHttpResponse(reactorResponse, (DataBufferFactory)bufferFactory);
            if (request.getMethod() == HttpMethod.HEAD) {
                response = new HttpHeadResponseDecorator(response);
            }
            if (logger.isDebugEnabled()) {
                return this.httpHandler.handle(request, response).doOnError(ex -> logger.trace("{}Failed to complete: {}", (Object)request.getLogPrefix(), (Object)ex.getMessage())).doOnSuccess(aVoid -> logger.trace("{}Handling completed", (Object)request.getLogPrefix()));
            }
            return this.httpHandler.handle(request, response);
        }
        catch (URISyntaxException ex2) {
            if (logger.isDebugEnabled()) {
                logger.debug("Failed to get request URI: " + ex2.getMessage());
            }
            reactorResponse.status(HttpResponseStatus.BAD_REQUEST);
            return Mono.empty();
        }
    }
}

