/*
 * Decompiled with CFR 0.152.
 */
package infra.http.server.reactive;

import infra.core.io.buffer.DataBufferFactory;
import infra.core.io.buffer.NettyDataBufferFactory;
import infra.http.HttpLogging;
import infra.http.HttpMethod;
import infra.http.server.reactive.HttpHandler;
import infra.http.server.reactive.HttpHeadResponseDecorator;
import infra.http.server.reactive.ReactorServerHttpRequest;
import infra.http.server.reactive.ReactorServerHttpResponse;
import infra.http.server.reactive.ServerHttpResponse;
import infra.lang.Assert;
import infra.logging.Logger;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.net.URISyntaxException;
import java.util.function.BiFunction;
import reactor.core.publisher.Mono;
import reactor.netty.http.server.HttpServerRequest;
import reactor.netty.http.server.HttpServerResponse;

public class ReactorHttpHandlerAdapter
implements BiFunction<HttpServerRequest, HttpServerResponse, Mono<Void>> {
    private static final Logger log = HttpLogging.forLogName(ReactorHttpHandlerAdapter.class);
    private final HttpHandler httpHandler;

    public ReactorHttpHandlerAdapter(HttpHandler httpHandler) {
        Assert.notNull((Object)httpHandler, (String)"HttpHandler is required");
        this.httpHandler = httpHandler;
    }

    @Override
    public Mono<Void> apply(HttpServerRequest reactorRequest, HttpServerResponse reactorResponse) {
        NettyDataBufferFactory bufferFactory = new NettyDataBufferFactory(reactorResponse.alloc());
        try {
            ServerHttpResponse response = new ReactorServerHttpResponse(reactorResponse, (DataBufferFactory)bufferFactory);
            ReactorServerHttpRequest request = new ReactorServerHttpRequest(reactorRequest, bufferFactory);
            if (request.getMethod() == HttpMethod.HEAD) {
                response = new HttpHeadResponseDecorator(response);
            }
            if (log.isDebugEnabled()) {
                return this.httpHandler.handle(request, response).doOnError(ex -> log.trace("{}Failed to complete: {}", (Object)request.getLogPrefix(), (Object)ex.getMessage())).doOnSuccess(aVoid -> log.trace("{}Handling completed", (Object)request.getLogPrefix()));
            }
            return this.httpHandler.handle(request, response);
        }
        catch (URISyntaxException ex2) {
            if (log.isDebugEnabled()) {
                log.debug("Failed to get request URI: {}", (Object)ex2.getMessage());
            }
            reactorResponse.status(HttpResponseStatus.BAD_REQUEST);
            return Mono.empty();
        }
    }
}

