/*
 * Decompiled with CFR 0.152.
 */
package infra.http.server.reactive;

import infra.core.io.buffer.DataBuffer;
import infra.core.io.buffer.DataBufferUtils;
import infra.http.HttpHeaders;
import infra.http.server.reactive.ServerHttpResponse;
import infra.http.server.reactive.ServerHttpResponseDecorator;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class HttpHeadResponseDecorator
extends ServerHttpResponseDecorator {
    public HttpHeadResponseDecorator(ServerHttpResponse delegate) {
        super(delegate);
    }

    @Override
    public final Mono<Void> writeWith(Publisher<? extends DataBuffer> body) {
        if (this.shouldSetContentLength() && body instanceof Mono) {
            return ((Mono)body).doOnSuccess(buffer -> {
                if (buffer != null) {
                    this.getHeaders().setContentLength(buffer.readableByteCount());
                    DataBufferUtils.release((DataBuffer)buffer);
                } else {
                    this.getHeaders().setContentLength(0L);
                }
            }).then();
        }
        return Flux.from(body).doOnNext(DataBufferUtils::release).then();
    }

    private boolean shouldSetContentLength() {
        HttpHeaders httpHeaders = this.getHeaders();
        return httpHeaders.getFirst("Content-Length") == null && httpHeaders.getFirst("Transfer-Encoding") == null;
    }

    @Override
    public final Mono<Void> writeAndFlushWith(Publisher<? extends Publisher<? extends DataBuffer>> body) {
        return this.setComplete();
    }
}

