/*
 * Decompiled with CFR 0.152.
 */
package infra.http.server.reactive;

import infra.http.HttpStatus;
import infra.http.server.reactive.HttpHandler;
import infra.http.server.reactive.ServerHttpRequest;
import infra.http.server.reactive.ServerHttpResponse;
import infra.lang.Assert;
import java.util.LinkedHashMap;
import java.util.Map;
import reactor.core.publisher.Mono;

public class ContextPathCompositeHandler
implements HttpHandler {
    private final LinkedHashMap<String, HttpHandler> handlerMap;

    public ContextPathCompositeHandler(Map<String, ? extends HttpHandler> handlerMap) {
        Assert.notEmpty(handlerMap, (String)"Handler map must not be empty");
        this.handlerMap = ContextPathCompositeHandler.initHandlers(handlerMap);
    }

    private static LinkedHashMap<String, HttpHandler> initHandlers(Map<String, ? extends HttpHandler> map) {
        map.keySet().forEach(ContextPathCompositeHandler::assertValidContextPath);
        return new LinkedHashMap<String, HttpHandler>(map);
    }

    private static void assertValidContextPath(String contextPath) {
        Assert.hasText((String)contextPath, (String)"Context path must not be empty");
        if (contextPath.equals("/")) {
            return;
        }
        Assert.isTrue((boolean)contextPath.startsWith("/"), (String)"Context path must begin with '/'");
        Assert.isTrue((!contextPath.endsWith("/") ? 1 : 0) != 0, (String)"Context path must not end with '/'");
    }

    @Override
    public Mono<Void> handle(ServerHttpRequest request, ServerHttpResponse response) {
        String path = request.getPath().pathWithinApplication().value();
        for (Map.Entry<String, HttpHandler> entry : this.handlerMap.entrySet()) {
            if (!path.startsWith(entry.getKey())) continue;
            String contextPath = request.getPath().contextPath().value() + entry.getKey();
            ServerHttpRequest newRequest = request.mutate().contextPath(contextPath).build();
            return entry.getValue().handle(newRequest, response);
        }
        response.setStatusCode(HttpStatus.NOT_FOUND);
        return response.setComplete();
    }
}

