/*
 * Decompiled with CFR 0.152.
 */
package infra.http.server.reactive;

import infra.core.io.buffer.DataBuffer;
import infra.core.io.buffer.DataBufferFactory;
import infra.core.io.buffer.DataBufferUtils;
import infra.http.HttpHeaders;
import infra.http.HttpStatus;
import infra.http.HttpStatusCode;
import infra.http.ResponseCookie;
import infra.http.server.reactive.ChannelSendOperator;
import infra.http.server.reactive.ServerHttpResponse;
import infra.lang.Assert;
import infra.lang.Nullable;
import infra.util.MultiValueMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public abstract class AbstractServerHttpResponse
implements ServerHttpResponse {
    @Nullable
    private Integer statusCode;
    @Nullable
    private HttpHeaders readOnlyHeaders;
    private final HttpHeaders headers;
    private final DataBufferFactory dataBufferFactory;
    private final MultiValueMap<String, ResponseCookie> cookies;
    private final AtomicReference<State> state = new AtomicReference<State>(State.NEW);
    private final CopyOnWriteArrayList<Supplier<? extends Mono<Void>>> commitActions = new CopyOnWriteArrayList();

    public AbstractServerHttpResponse(DataBufferFactory dataBufferFactory) {
        this(dataBufferFactory, HttpHeaders.forWritable());
    }

    public AbstractServerHttpResponse(DataBufferFactory dataBufferFactory, HttpHeaders headers) {
        Assert.notNull((Object)dataBufferFactory, (String)"DataBufferFactory is required");
        Assert.notNull((Object)headers, (String)"HttpHeaders is required");
        this.headers = headers;
        this.dataBufferFactory = dataBufferFactory;
        this.cookies = MultiValueMap.forLinkedHashMap();
    }

    @Override
    public final DataBufferFactory bufferFactory() {
        return this.dataBufferFactory;
    }

    @Override
    public boolean setStatusCode(@Nullable HttpStatus status) {
        if (this.state.get() == State.COMMITTED) {
            return false;
        }
        this.statusCode = status != null ? Integer.valueOf(status.value()) : null;
        return true;
    }

    @Override
    @Nullable
    public HttpStatusCode getStatusCode() {
        return this.statusCode != null ? HttpStatus.resolve(this.statusCode) : null;
    }

    @Override
    public boolean setRawStatusCode(@Nullable Integer statusCode) {
        if (this.state.get() == State.COMMITTED) {
            return false;
        }
        this.statusCode = statusCode;
        return true;
    }

    @Override
    @Nullable
    public Integer getRawStatusCode() {
        return this.statusCode;
    }

    @Override
    public HttpHeaders getHeaders() {
        if (this.readOnlyHeaders != null) {
            return this.readOnlyHeaders;
        }
        if (this.state.get() == State.COMMITTED) {
            this.readOnlyHeaders = this.headers.asReadOnly();
            return this.readOnlyHeaders;
        }
        return this.headers;
    }

    @Override
    public MultiValueMap<String, ResponseCookie> getCookies() {
        return this.state.get() == State.COMMITTED ? this.cookies.asReadOnly() : this.cookies;
    }

    @Override
    public void addCookie(ResponseCookie cookie) {
        Assert.notNull((Object)cookie, (String)"ResponseCookie is required");
        if (this.state.get() == State.COMMITTED) {
            throw new IllegalStateException("Can't add the cookie " + cookie + "because the HTTP response has already been committed");
        }
        this.getCookies().add((Object)cookie.getName(), (Object)cookie);
    }

    public abstract <T> T getNativeResponse();

    @Override
    public void beforeCommit(Supplier<? extends Mono<Void>> action) {
        this.commitActions.add(action);
    }

    @Override
    public boolean isCommitted() {
        State state = this.state.get();
        return state != State.NEW && state != State.COMMIT_ACTION_FAILED;
    }

    @Override
    public final Mono<Void> writeWith(Publisher<? extends DataBuffer> body) {
        if (body instanceof Mono) {
            return ((Mono)body).flatMap(buffer -> {
                this.touchDataBuffer((DataBuffer)buffer);
                AtomicBoolean subscribed = new AtomicBoolean();
                return this.doCommit(() -> {
                    try {
                        return this.writeWithInternal((Publisher<? extends DataBuffer>)Mono.fromCallable(() -> buffer).doOnSubscribe(s -> subscribed.set(true)).doOnDiscard(DataBuffer.class, DataBufferUtils::release));
                    }
                    catch (Throwable ex) {
                        return Mono.error((Throwable)ex);
                    }
                }).doOnError(ex -> DataBufferUtils.release((DataBuffer)buffer)).doOnCancel(() -> {
                    if (!subscribed.get()) {
                        DataBufferUtils.release((DataBuffer)buffer);
                    }
                });
            }).doOnError(t -> this.getHeaders().clearContentHeaders()).doOnDiscard(DataBuffer.class, DataBufferUtils::release);
        }
        return new ChannelSendOperator<DataBuffer>(body, inner -> this.doCommit(() -> this.writeWithInternal((Publisher<? extends DataBuffer>)inner))).doOnError(t -> this.getHeaders().clearContentHeaders());
    }

    @Override
    public final Mono<Void> writeAndFlushWith(Publisher<? extends Publisher<? extends DataBuffer>> body) {
        return new ChannelSendOperator<Publisher<? extends DataBuffer>>(body, inner -> this.doCommit(() -> this.writeAndFlushWithInternal((Publisher<? extends Publisher<? extends DataBuffer>>)inner))).doOnError(t -> this.getHeaders().clearContentHeaders());
    }

    @Override
    public Mono<Void> setComplete() {
        return !this.isCommitted() ? this.doCommit(null) : Mono.empty();
    }

    protected Mono<Void> doCommit() {
        return this.doCommit(null);
    }

    protected Mono<Void> doCommit(@Nullable Supplier<? extends Mono<Void>> writeAction) {
        Flux allActions = Flux.empty();
        if (this.state.compareAndSet(State.NEW, State.COMMITTING)) {
            if (!this.commitActions.isEmpty()) {
                allActions = Flux.concat((Publisher)Flux.fromIterable(this.commitActions).map(Supplier::get)).doOnError(ex -> {
                    if (this.state.compareAndSet(State.COMMITTING, State.COMMIT_ACTION_FAILED)) {
                        this.getHeaders().clearContentHeaders();
                    }
                });
            }
        } else if (!this.state.compareAndSet(State.COMMIT_ACTION_FAILED, State.COMMITTING)) {
            return Mono.empty();
        }
        allActions = allActions.concatWith((Publisher)Mono.fromRunnable(() -> {
            this.applyStatusCode();
            this.applyHeaders();
            this.applyCookies();
            this.state.set(State.COMMITTED);
        }));
        if (writeAction != null) {
            allActions = allActions.concatWith((Publisher)writeAction.get());
        }
        return allActions.then();
    }

    protected abstract Mono<Void> writeWithInternal(Publisher<? extends DataBuffer> var1);

    protected abstract Mono<Void> writeAndFlushWithInternal(Publisher<? extends Publisher<? extends DataBuffer>> var1);

    protected abstract void applyStatusCode();

    protected abstract void applyHeaders();

    protected abstract void applyCookies();

    protected void touchDataBuffer(DataBuffer buffer) {
    }

    private static enum State {
        NEW,
        COMMITTING,
        COMMIT_ACTION_FAILED,
        COMMITTED;

    }
}

