/*
 * Decompiled with CFR 0.152.
 */
package infra.http.server;

import infra.http.server.DefaultPathContainer;
import infra.util.MultiValueMap;
import java.util.List;

public abstract class PathContainer {
    public abstract String value();

    public abstract List<Element> elements();

    public PathContainer subPath(int index) {
        return this.subPath(index, this.elements().size());
    }

    public PathContainer subPath(int startIndex, int endIndex) {
        return DefaultPathContainer.subPath(this, startIndex, endIndex);
    }

    public static PathContainer parsePath(String path) {
        return DefaultPathContainer.createFromUrlPath(path, Options.HTTP_PATH);
    }

    public static PathContainer parsePath(String path, Options options) {
        return DefaultPathContainer.createFromUrlPath(path, options);
    }

    public static PathContainer empty() {
        return DefaultPathContainer.EMPTY_PATH;
    }

    public record Options(char separator, boolean decodeAndParseSegments) {
        public static final Options HTTP_PATH = Options.create('/', true);
        public static final Options MESSAGE_ROUTE = Options.create('.', false);

        public boolean shouldDecodeAndParseSegments() {
            return this.decodeAndParseSegments;
        }

        public static Options create(char separator, boolean decodeAndParseSegments) {
            return new Options(separator, decodeAndParseSegments);
        }
    }

    public static interface PathSegment
    extends Element {
        public String valueToMatch();

        public char[] valueToMatchAsChars();

        public MultiValueMap<String, String> parameters();
    }

    public static interface Separator
    extends Element {
    }

    public static interface Element {
        public String value();
    }
}

