/*
 * Decompiled with CFR 0.152.
 */
package infra.http.server;

import infra.http.HttpHeaders;
import infra.http.HttpStatusCode;
import infra.http.server.ServerHttpResponse;
import infra.lang.Assert;
import java.io.IOException;
import java.io.OutputStream;

public class DelegatingServerHttpResponse
implements ServerHttpResponse {
    private final ServerHttpResponse delegate;

    public DelegatingServerHttpResponse(ServerHttpResponse delegate) {
        Assert.notNull((Object)delegate, (String)"Delegate is required");
        this.delegate = delegate;
    }

    public ServerHttpResponse getDelegate() {
        return this.delegate;
    }

    @Override
    public void setStatusCode(HttpStatusCode status) {
        this.delegate.setStatusCode(status);
    }

    @Override
    public void flush() throws IOException {
        this.delegate.flush();
    }

    @Override
    public void close() {
        this.delegate.close();
    }

    @Override
    public OutputStream getBody() throws IOException {
        return this.delegate.getBody();
    }

    @Override
    public HttpHeaders getHeaders() {
        return this.delegate.getHeaders();
    }
}

