/*
 * Decompiled with CFR 0.152.
 */
package infra.http.server;

import infra.http.server.PathContainer;
import infra.http.server.RequestPath;
import infra.lang.Nullable;
import infra.util.StringUtils;
import java.util.List;

class DefaultRequestPath
extends RequestPath {
    private final PathContainer fullPath;
    private final PathContainer contextPath;
    private final PathContainer pathWithinApplication;

    DefaultRequestPath(String rawPath, @Nullable String contextPath) {
        this(PathContainer.parsePath(rawPath), contextPath);
    }

    private DefaultRequestPath(PathContainer fullPath, @Nullable String contextPath) {
        this.fullPath = fullPath;
        this.contextPath = DefaultRequestPath.initContextPath(fullPath, contextPath);
        this.pathWithinApplication = contextPath == null ? fullPath : fullPath.subPath(this.contextPath.elements().size());
    }

    private static PathContainer initContextPath(PathContainer path, @Nullable String contextPath) {
        if (contextPath == null || StringUtils.isBlank((String)contextPath) || StringUtils.matchesCharacter((String)contextPath, (char)'/')) {
            return PathContainer.empty();
        }
        DefaultRequestPath.validateContextPath(path.value(), contextPath);
        int length = contextPath.length();
        int counter = 0;
        List<PathContainer.Element> elements = path.elements();
        int size = elements.size();
        for (int i = 0; i < size; ++i) {
            PathContainer.Element element = elements.get(i);
            if (length != (counter += element.value().length())) continue;
            return path.subPath(0, i + 1);
        }
        throw new IllegalStateException("Failed to initialize contextPath '%s' for requestPath '%s'".formatted(contextPath, path.value()));
    }

    private static void validateContextPath(String fullPath, String contextPath) {
        int length = contextPath.length();
        if (contextPath.charAt(0) != '/' || contextPath.charAt(length - 1) == '/') {
            throw new IllegalArgumentException("Invalid contextPath: '%s': must start with '/' and not end with '/'".formatted(contextPath));
        }
        if (!fullPath.startsWith(contextPath)) {
            throw new IllegalArgumentException("Invalid contextPath '%s': must match the start of requestPath: '%s'".formatted(contextPath, fullPath));
        }
        if (fullPath.length() > length && fullPath.charAt(length) != '/') {
            throw new IllegalArgumentException("Invalid contextPath '%s': must match to full path segments for requestPath: '%s'".formatted(contextPath, fullPath));
        }
    }

    @Override
    public String value() {
        return this.fullPath.value();
    }

    @Override
    public List<PathContainer.Element> elements() {
        return this.fullPath.elements();
    }

    @Override
    public PathContainer contextPath() {
        return this.contextPath;
    }

    @Override
    public PathContainer pathWithinApplication() {
        return this.pathWithinApplication;
    }

    @Override
    public RequestPath modifyContextPath(@Nullable String contextPath) {
        return new DefaultRequestPath(this, contextPath);
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        DefaultRequestPath otherPath = (DefaultRequestPath)other;
        return this.fullPath.equals(otherPath.fullPath) && this.contextPath.equals(otherPath.contextPath) && this.pathWithinApplication.equals(otherPath.pathWithinApplication);
    }

    public int hashCode() {
        int result = this.fullPath.hashCode();
        result = 31 * result + this.contextPath.hashCode();
        result = 31 * result + this.pathWithinApplication.hashCode();
        return result;
    }

    public String toString() {
        return this.fullPath.toString();
    }
}

